/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form.base;

import org.eclipse.emf.ecore.EStructuralFeature;

/**
 * The only purpose of this interface is to ensure that the form which implements
 * it has a structural feature (@see org.eclipse.emf.ecore.EStructuralFeature) to
 * reveal.
 * @author bcormier
 * @since 3.0.0
 */
public interface IHasEStructuralFeature {
    
    
	/**
	 * If the form which implements this interface has
	 * a structural feature (EStructuralFeature) that might need to
	 * be revealed, then this method must return it.
	 * @return the structural feature
	 */
	public EStructuralFeature getStructuralFeature();

}