/* 
* IBM Confidential
* OCO Source Materials
* %ProductName%
*  Copyright IBM Corp. 2004
*
* The source code for this program is not published or 
* otherwise divested of its trade secrets, irrespective of what 
* has been deposited with the U.S. Copyright Office.
*/
package org.eclipse.hyades.test.ui.internal.action;

import java.util.Iterator;

import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveChildrenAction;
import org.eclipse.jface.viewers.IStructuredSelection;


/**
 * This IAction is used to remove a Datapool record from a table.
 * @author bcormier
 * @since 3.0.0
 *
 */
public class DeleteDatapoolAction extends RemoveChildrenAction {
    private TPFTestSuite testSuite;
    
    /**
     * The constructor for the class
     */
    public DeleteDatapoolAction() {
        super(false);
    }
    
    /**
     * @see org.eclipse.ui.actions.BaseSelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
     */
    protected boolean updateSelection(IStructuredSelection selection) {
		if (selection == null) 
			return false;
			
		if (!(selection.getFirstElement() instanceof DPLDatapool))
		    return false;
		return true;
    }
    
    /**
     * @see org.eclipse.jface.action.IAction#run()
     */
    public void run() {
        if (getTestSuite()==null || getTestSuite().getDatapools()==null) 
            return;
        IStructuredSelection selection = getStructuredSelection();
        for (Iterator iter = selection.iterator(); iter.hasNext();) {
            Object tmp = iter.next();
            if ((tmp instanceof DPLDatapool) && getTestSuite().getDatapools().contains(tmp)) {
                getTestSuite().getDatapools().remove(tmp);
            }
        }
    }

    /**
     * @return Returns the test context.
     */
    public TPFTestSuite getTestSuite() {
        return testSuite;
    }
    
    /**
     * @param testSuite The test context to set.
     */
    public void setTestSuite(TPFTestSuite testSuite) {
        this.testSuite = testSuite;
    }
}
