/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.HashMap;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.IEventLabelProvider;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

/**
 * @author kdarcour
 *
 */
public class EventLabelProvider implements ILabelProvider 
{
	private HashMap providers;
	
	/**
	 * Constructor for EventLabelProvider
	 */
	public EventLabelProvider() 
	{
		providers = new HashMap();
		IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".executionHistoryExtension"); //$NON-NLS-1$
		if (extPoint != null) 
		{
			IConfigurationElement[] members = extPoint.getConfigurationElements();
			String typeName;
			for (int i = 0; i < members.length; i++) 
			{
				if (members[i].getName() != null) 
				{
					//- init providers map
					IConfigurationElement element = members[i];
					typeName = element.getAttribute("targetType"); //$NON-NLS-1$
					providers.put(typeName,element);
				}
			}
		}	
	}
	
	public IEventLabelProvider getProvider(String type) 
	{
		IEventLabelProvider provider = null;
		if(providers.containsKey(type)) 
		{
			Object value = providers.get(type);
			if (value instanceof IConfigurationElement) 
			{
				IConfigurationElement element = (IConfigurationElement) value;
				try 
				{
					provider = (IEventLabelProvider) element.createExecutableExtension("provider");//$NON-NLS-1$
					providers.put(type, provider);
				} 
				catch (CoreException e) 
				{
					TestUIPlugin.logInfo("Unable to retrieve provider");//$NON-NLS-1$ 
				} 
			}
		}
		return provider;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
	 */
	public Image getImage(Object element) 
	{
		Image icon = null;
		DefaultLabelProvider defaultProv = new DefaultLabelProvider();
		if (element instanceof TPFExecutionResult) 
		{
			TPFExecutionResult execResult = (TPFExecutionResult) element;
			IEventLabelProvider provider = getProvider(execResult.getType());
			if(provider != null) 
				icon = provider.getImage(element);
			else
				icon = defaultProv.getImage(element); 
		} 
		else if (element instanceof TPFExecutionEvent) 
		{
			TPFExecutionEvent execEvent = (TPFExecutionEvent) element;
			IEventLabelProvider provider = getProvider(execEvent.getEventType());
			if(provider != null) 
				icon = provider.getImage(element);
			else 
				icon = defaultProv.getImage(element);
		}		
		return icon;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element) 
	{
		String label = "";
		DefaultLabelProvider defaultProv = new DefaultLabelProvider();
		if (element instanceof TPFExecutionResult) 
		{
			TPFExecutionResult execResult = (TPFExecutionResult) element;
			IEventLabelProvider provider = getProvider(execResult.getType());
			if(provider != null) 
				label = provider.getText(element);
			else
				label = defaultProv.getText(element); 
		} 
		else if (element instanceof TPFExecutionEvent) 
		{
			TPFExecutionEvent execEvent = (TPFExecutionEvent) element;
			IEventLabelProvider provider = getProvider(execEvent.getEventType());
			if(provider != null) 
				label = provider.getText(element);
			else
				label = defaultProv.getText(element); 
		}
		return label;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() {
		// TODO Auto-generated method stub
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
	 */
	public boolean isLabelProperty(Object element, String property) {
		// TODO Auto-generated method stub
		return false;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub
	}
}
