/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.ui.internal.preference;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.report.ReportDescription;
import org.eclipse.hyades.ui.internal.report.ReportManager;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.report.IReportDescription;

public class ReportGeneratorPage
	extends PreferencePage
	implements IWorkbenchPreferencePage, SelectionListener {

	private final static String[] COLUMNS = { "STRING", "STRING" }; //$NON-NLS-1$ //$NON-NLS-2$

	private ReportManager reportManager;
	
	private TableViewer tableViewer;
	private ArrayList tableElements = new ArrayList();
	private Button btnAdd;
	private Button btnRemove;
	private Button btnRename;
	private Button btnTest;
	
	private class ReportGeneratorUI implements SelectionListener, ModifyListener
	{
		private Text      _classname;
		private Text      _name; 
		private Text      _classpath;
		private Button    _browseClass;
		private Button    _browseDirPath;
		private Button    _browseJarPath; 
		private Shell shell;
		private Listener  _listener;
		
	  public ReportGeneratorUI(Shell shell)    
	  {
		super();
		this.shell = shell;
	  }  
	/**
	 * Insert the method's description here.
	 * Creation date: (8/10/2001 12:39:10 PM)
	 * @return org.eclipse.swt.widgets.Composite
	 * @param parent org.eclipse.swt.widgets.Composite
	 */
	public Composite createArgumentsControl(Composite parent)
	{
		GridData gd;
	
		Label label = new Label(parent, SWT.NULL);
		gd = new GridData();
		gd.verticalAlignment = GridData.BEGINNING;  
		label.setText(TestUIPlugin.getString("CLASSPATH")); //$NON-NLS-1$
		label.setLayoutData(gd);
	
		_classpath = new Text(parent, SWT.BORDER|SWT.MULTI|SWT.H_SCROLL|SWT.V_SCROLL|SWT.WRAP);
		gd = GridDataUtil.createFill();
		gd.heightHint = 100;
		gd.widthHint = 250;	
		_classpath.setLayoutData(gd);

		Composite btnGroup = new Composite(parent, SWT.NULL);
		gd = GridDataUtil.createVerticalFill();
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		btnGroup.setLayoutData(gd);
		btnGroup.setLayout(layout);
    
		_browseDirPath = new Button(btnGroup,  SWT.CENTER | SWT.PUSH);
	
		gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;
		gd.verticalAlignment = GridData.FILL;               	
		_browseDirPath.setLayoutData(gd);
	
		_browseDirPath.setText(TestUIPlugin.getString("ADD_DIRECTORY")); //$NON-NLS-1$
		_browseJarPath = new Button(btnGroup,  SWT.CENTER | SWT.PUSH);
	
		gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;
		gd.verticalAlignment = GridData.VERTICAL_ALIGN_BEGINNING;  
	
		_browseJarPath.setLayoutData(gd);
	
		_browseJarPath.setText(TestUIPlugin.getString("ADD_JAR")); //$NON-NLS-1$

		//add listeners
		_browseDirPath.addSelectionListener(this);
		_browseJarPath.addSelectionListener(this);  

		_classname.addModifyListener(this);

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_classpath,
			TestUIPlugin.getID()+".lpui0001"); //$NON-NLS-1$
	
	
		return parent;
	}
	  public Composite createControl(Composite parent)
	  {
		Label label;
 
		Composite content = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		layout.verticalSpacing=5; 
		layout.horizontalSpacing = 5;      
		content.setLayout(layout);
		GridData gd = GridDataUtil.createFill();
		gd.horizontalIndent = 5;
		content.setLayoutData(gd);

		label = new Label(content, SWT.NULL);	
		label.setText(TestUIPlugin.getString("label.Name")); //$NON-NLS-1$
		_name = new Text(content, SWT.SINGLE | SWT.BORDER);
		gd = GridDataUtil.createHorizontalFill();
		gd.horizontalSpan = 2;
		_name.setLayoutData(gd);	
	
		label = new Label(content, SWT.NONE);
		label.setText(TestUIPlugin.getString("preference.report.Classfile")); //$NON-NLS-1$
		_classname = new Text(content, SWT.SINGLE | SWT.BORDER);
		_classname.setLayoutData(GridDataUtil.createHorizontalFill());
	
		Composite btnGroup = new Composite(content, SWT.NULL);
		gd = GridDataUtil.createVerticalFill();
		layout = new GridLayout();
		layout.numColumns = 1;
		btnGroup.setLayoutData(gd);
		btnGroup.setLayout(layout);
	
		_browseClass = new Button(btnGroup,  SWT.CENTER | SWT.PUSH);
		gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;
		_browseClass.setLayoutData(gd);
		_browseClass.setText(TestUIPlugin.getString("BROWSE"));	//$NON-NLS-1$

		//add listeners
		_browseClass.addSelectionListener(this);
		_name.setFocus();
		_name.addModifyListener(this);

		createArgumentsControl(content);
		
		WorkbenchHelp.setHelp(_classname, TestUIPlugin.getID() + ContextIds.REP_GEN_PREF_CLASNDLG);										
		WorkbenchHelp.setHelp(_classpath, TestUIPlugin.getID() + ContextIds.REP_GEN_PREF_CLAPDLG);										
		WorkbenchHelp.setHelp(_name, TestUIPlugin.getID() + ContextIds.REP_GEN_PREF_NDLG);										
		WorkbenchHelp.setHelp(_browseClass, TestUIPlugin.getID() + ContextIds.REP_GEN_PREF_BCDLG);										
		WorkbenchHelp.setHelp(_browseDirPath, TestUIPlugin.getID() + ContextIds.REP_GEN_PREF_BDDLG);										
		WorkbenchHelp.setHelp(_browseJarPath, TestUIPlugin.getID() + ContextIds.REP_GEN_PREF_BJDLG);										

		return content;
	  }    
	/**
	 * Insert the method's description here.
	 * Creation date: (5/8/2001 2:39:07 PM)
	 * @param enable boolean
	 */
	public void enable(boolean enableClassName, boolean enableArgs
					   , boolean enableBrowseClass, boolean enableBrowseArgs, boolean enableEnv)
	{
		_classname.setEnabled(enableClassName);
		_browseClass.setEnabled(enableBrowseClass);

		_classpath.setEnabled(enableArgs);		
		_name.setEnabled(enableArgs);
		_browseDirPath.setEnabled(enableBrowseArgs);
		_browseJarPath.setEnabled(enableBrowseArgs);   
	
		if(enableClassName)
		{
		  _classname.setFocus();
		  _classname.selectAll();
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (5/8/2001 12:25:04 PM)
	 * @return java.lang.String
	 */
	public String getClassName() {
		return _classname.getText().trim();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (5/8/2001 12:25:04 PM)
	 * @return java.lang.String
	 */
	public String getClassPath()
	{
		return _classpath.getText().trim();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (5/8/2001 12:25:04 PM)
	 * @return java.lang.String
	 */
	public Text getClassUI() {
		return _classname;
	}

	public Control getBrowseJarButton() {
		return _browseJarPath;
	}

	public Control getBrowseDirButton() {
		return _browseDirPath;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (5/8/2001 12:25:04 PM)
	 * @return java.lang.String
	 */
	public String getName() {
		return _name.getText().trim();
	}
	public void widgetDefaultSelected(SelectionEvent event) {}
	/**
	 * Insert the method's description here.
	 * Creation date: (08/21/2000 7:49:33 PM)
	 * @param e com.ibm.swt.events.SelectionEvent
	 */
	public void widgetSelected(SelectionEvent e)
	{
		String osName = System.getProperty("os.name"); //$NON-NLS-1$
		
		if(e.widget == _browseClass)
		{
			FileDialog dlg = new FileDialog(shell);
			dlg.setFilterExtensions(new String[] {"*.class"}); //$NON-NLS-1$
			dlg.open();

			String fileName = dlg.getFileName();
			if(fileName != null && !fileName.equals("")) //$NON-NLS-1$
			{
			  if(fileName.endsWith(".class")) //$NON-NLS-1$
				   fileName = fileName.substring(0, fileName.length()-6);

			   _classname.setText(fileName);
		   
			   String classpath = dlg.getFilterPath();
				if ((osName != null) && (osName.startsWith("Windows")) && (classpath.endsWith(":"))) //$NON-NLS-1$ //$NON-NLS-2$
				{
					classpath += "\\"; //$NON-NLS-1$
				}

				String oldClassPath=_classpath.getText().trim();                   
				oldClassPath=oldClassPath.equals("")||oldClassPath.endsWith(File.pathSeparator)? //$NON-NLS-1$
							oldClassPath:oldClassPath+File.pathSeparator;
				_classpath.setText(oldClassPath+classpath);

			}       
		
		}
		else if(e.widget == _browseDirPath)
		{
			DirectoryDialog dlg = new DirectoryDialog(shell);
			String classpath = dlg.open();
		
			if(classpath != null && !classpath.equals("")) //$NON-NLS-1$
			{

				if ((osName != null) && (osName.startsWith("Windows")) && (classpath.endsWith(":"))) //$NON-NLS-1$ //$NON-NLS-2$
				{
					classpath += "\\"; //$NON-NLS-1$
				}

				String oldClassPath=_classpath.getText().trim();
				oldClassPath=oldClassPath.equals("")||oldClassPath.endsWith(File.pathSeparator)? //$NON-NLS-1$
							oldClassPath:oldClassPath+File.pathSeparator;
				classpath = oldClassPath+classpath;	
				_classpath.setText(classpath);
				_classpath.setFocus();
			}
		
		}
		else if(e.widget == _browseJarPath)
		{
			FileDialog dlg = new FileDialog(shell);
			dlg.setFilterExtensions(new String[] {"*.jar;*.zip"}); //$NON-NLS-1$    
			dlg.open();

			String classpath = dlg.getFileName();

			if(classpath != null && !classpath.equals("")) //$NON-NLS-1$
			{
				classpath = dlg.getFilterPath() + File.separator + classpath;

				String oldClassPath=_classpath.getText().trim();
				oldClassPath=oldClassPath.equals("")||oldClassPath.endsWith(File.pathSeparator)? //$NON-NLS-1$
							oldClassPath:oldClassPath+File.pathSeparator;
				classpath = oldClassPath+classpath;					
				_classpath.setText(classpath);
			}               
		}
	}

		/**
		 * Sent when the text is modified.
		 *
		 * @param e an event containing information about the modify
		 */
		public void modifyText(ModifyEvent e)
		{
			notifyListener();
		}

		/**
		 * @param text
		 */
		public void setClassname(String text) {
			_classname.setText(text);
		}

		/**
		 * @param text
		 */
		public void setClasspath(String text) {
			
			if(text != null)
				_classpath.setText(text);
		}

		/**
		 * @param text
		 */
		public void setName(String text) {
			_name.setText(text);
		}

		public void registerListener(Listener listener){
			_listener = listener;
		
		}

		public void notifyListener(){
		
			if(_listener != null)
			   _listener.handleEvent(null);
		}

	}
	
	private class PreferenceContentProvider implements IStructuredContentProvider {
		/**
		 * @see IStructuredContentProvider#getElements(Object)
		 */
		public Object[] getElements(Object element) {
			if (element instanceof ArrayList)
				return ((ArrayList)element).toArray();

			return new Object[0];
		}
		/**
		 * @see IContentProvider#dispose()
		 */
		public void dispose() {
		}
		/**
		 * @see IContentProvider#inputChanged(Viewer, Object, Object)
		 */
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}
	}
	private class PreferenceLabelProvider
		extends LabelProvider
		implements ITableLabelProvider {
		/**
		 * @see ITableLabelProvider#getColumnImage(Object, int)
		 */
		public Image getColumnImage(Object element, int columnIndex) {
			
			if(columnIndex == 0)			
				return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_REPORT);
				
			return null;	
		}
		/**
		 * @see ITableLabelProvider#getColumnText(Object, int)
		 */
		public String getColumnText(Object element, int columnIndex) {
			if (element instanceof ReportDescription) {
				ReportDescription myTableElement = (ReportDescription) element;

				if (columnIndex == 0)
					return myTableElement.getName();

				if (columnIndex == 1)
					return myTableElement.getClassName();
			}
			return ""; //$NON-NLS-1$
		}
	}
	
	public class ReportDialog extends Dialog implements Listener{
        private ReportDescription report;
        private ReportGeneratorUI reportGeneratorUI;
		
		public ReportDialog(Shell shell, ReportDescription report){
			super(shell);
			this.report = report;
		}
		
		protected Control createDialogArea(Composite parent){ 

            if(report == null)
				getShell().setText(TestUIPlugin.getString("ADD_REPORT_DESC_DLG")); //$NON-NLS-1$
			else	
				getShell().setText(TestUIPlugin.getString("EDIT_REPORT_DESC_DLG")); //$NON-NLS-1$
			
			Composite result = new Composite(parent, SWT.NULL);
			result.setLayoutData(GridDataUtil.createFill());
			result.setLayout(new GridLayout());
			
			reportGeneratorUI = new ReportGeneratorUI(getShell());
			Composite content = reportGeneratorUI.createControl(result);
			
			if(report != null)
			{
				reportGeneratorUI.setName(report.getName());
				reportGeneratorUI.setClassname(report.getClassName());
				reportGeneratorUI.setClasspath(report.getClassPath());				
			}
			
			WorkbenchHelp.setHelp(content, TestUIPlugin.getID() + ContextIds.REP_GEN_PREF_DLG);										

			return content;
		}
		
		protected Control createButtonBar(Composite parent) {
			Control control = super.createButtonBar(parent);
			reportGeneratorUI.registerListener(this);
			
			if(report == null)			
				getButton(IDialogConstants.OK_ID).setEnabled(false);
			
			return control;
			
		}
		
		protected void okPressed(){

            if(report == null)
            {
				report = new ReportDescription(getClass().getClassLoader(), reportGeneratorUI.getName(), 
												reportGeneratorUI.getClassName(),
												reportGeneratorUI.getClassPath());
				            	
            }
			else
			{	
				report.setName(reportGeneratorUI.getName());
				report.setClassName(reportGeneratorUI.getClassName());
				report.setClassPath(reportGeneratorUI.getClassPath());
			}
			
			super.okPressed();
		}
		
		public ReportDescription getReportDefinition()
		{
			return report;
		}

		public void handleEvent(Event e){
			getButton(IDialogConstants.OK_ID).setEnabled(!reportGeneratorUI.getName().equals("") //$NON-NLS-1$
			   && !reportGeneratorUI.getClassName().equals("")); //$NON-NLS-1$	
		}
	}

	public ReportGeneratorPage() {
		super();
		setPreferenceStore(TestUIPlugin.getInstance().getPreferenceStore());
		reportManager = TestUI.getReportManager();
	}
	
	protected Control createContents(Composite parent) {
		
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayoutData(GridDataUtil.createFill());
		composite.setLayout(new GridLayout());

		createTable(composite);
		
		WorkbenchHelp.setHelp(parent, TestUIPlugin.getID() + ContextIds.REP_GEN_PREF_CONT);										
		
		return composite;
	}
	
	private Control createTable(Composite parent)
	{		
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.marginWidth = 5;
		layout.verticalSpacing = 10;
		layout.numColumns = 2;
		composite.setLayout(layout);
		composite.setLayoutData(GridDataUtil.createFill());
		
		GridData data = new GridData();
		data.horizontalSpan = 2;
				
		createTableViewer(composite);

		Composite buttons = new Composite(composite, SWT.NONE);
		data = new GridData(GridData.FILL_VERTICAL);
		data.widthHint = 90;
		buttons.setLayoutData(data);
		layout = new GridLayout();
		layout.numColumns = 1;
		buttons.setLayout(layout);
		
		createButtons(buttons);
		initializeValues();
		
		btnAdd.addSelectionListener(this);
		btnRename.addSelectionListener(this);
		btnRemove.addSelectionListener(this);
		btnTest.addSelectionListener(this);
		
		return composite;
	}
	
	private void createTableViewer(Composite parent) {
		// Create the table viewer.
		tableViewer =
			new TableViewer(
				parent,
				SWT.BORDER | SWT.SINGLE | SWT.FULL_SELECTION );

		// Create the table control.
		Table table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		GridData data = GridDataUtil.createFill();
		data.heightHint = 50;
		data.widthHint = 100;
		table.setLayoutData(data);

		TableLayout tableLayout = new TableLayout();
		CellEditor[] cellEditors = new CellEditor[COLUMNS.length];

		TableColumn nameColumn = new TableColumn(table, SWT.LEFT);
		nameColumn.setText(TestUIPlugin.getString("REP_COL_NAME")); //$NON-NLS-1$
		tableLayout.addColumnData(new ColumnWeightData(60));
		cellEditors[0] = new TextCellEditor(table);

		TableColumn certificateColumn = new TableColumn(table, SWT.LEFT);
		certificateColumn.setText(TestUIPlugin.getString("REP_COL_FILE")); //$NON-NLS-1$
		tableLayout.addColumnData(new ColumnWeightData(40));

		table.setLayout(tableLayout);
		

		// Adjust the table viewer.
		tableViewer.setColumnProperties(COLUMNS);
		tableViewer.setContentProvider(new PreferenceContentProvider());
		tableViewer.setLabelProvider(new PreferenceLabelProvider());
		tableViewer.addFilter(new ViewerFilter()
		{
			public boolean select(Viewer viewer, Object parentElement, Object element)
			{
				return ((element instanceof ReportDescription) && (!((ReportDescription)element).isDefinedByPlugin()));
			}
		});
		tableViewer.getTable().addSelectionListener(this);
		
		WorkbenchHelp.setHelp(tableViewer.getTable(), TestUIPlugin.getID() + ContextIds.REP_GEN_PREF_TABLE);										
		
	}
	
	private void createButtons(Composite parent){
		
		btnAdd = new Button(parent, SWT.PUSH);
		btnAdd.setText(TestUIPlugin.getString("label.Add")); //$NON-NLS-1$
		GridData data = GridDataUtil.createHorizontalFill();
		data.widthHint = 20;
		btnAdd.setLayoutData(data);
		
		btnRemove = new Button(parent, SWT.PUSH);
		btnRemove.setText(TestUIPlugin.getString("label.Remove")); //$NON-NLS-1$
		data = GridDataUtil.createHorizontalFill();
		data.widthHint = 20;
		btnRemove.setLayoutData(data);
		btnRemove.setEnabled(false);		

		Composite space = new Composite(parent, SWT.NONE);
		data = GridDataUtil.createHorizontalFill();
		data.verticalSpan = 2;
		//data.horizontalIndent = 6;
		space.setLayoutData(data);

		btnRename = new Button(parent, SWT.PUSH);
		btnRename.setText(TestUIPlugin.getString("label.Update")); //$NON-NLS-1$
		data = GridDataUtil.createHorizontalFill();
		data.widthHint = 20;
		btnRename.setLayoutData(data);
		btnRename.setEnabled(false);
		
		btnTest = new Button(parent, SWT.PUSH);
		btnTest.setText(TestUIPlugin.getString("label.Test")); //$NON-NLS-1$
		data = GridDataUtil.createHorizontalFill();
		data.widthHint = 20;
		btnTest.setLayoutData(data);
		btnTest.setEnabled(false);
		
		WorkbenchHelp.setHelp(btnAdd, TestUIPlugin.getID() + ContextIds.REP_GEN_PREF_ADDB);										
		WorkbenchHelp.setHelp(btnRemove, TestUIPlugin.getID() + ContextIds.REP_GEN_PREF_DELB);										
		WorkbenchHelp.setHelp(btnRename, TestUIPlugin.getID() + ContextIds.REP_GEN_PREF_EDITB);										
		WorkbenchHelp.setHelp(btnTest, TestUIPlugin.getID() + ContextIds.REP_GEN_PREF_TESTB);										

	}


	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent event) {
		
		if(event.widget == btnAdd)
		{
			ReportDialog dlg = new ReportDialog(getShell(), null);
			dlg.open();
			
			if(dlg.getReturnCode() == Window.OK)
			{
				IReportDescription rptDesc = dlg.getReportDefinition();
				reportManager.addReportDefinition(rptDesc);
				tableElements.add(rptDesc);
				tableViewer.refresh();	
				
				tableViewer.setSelection(new StructuredSelection(rptDesc));		
			}
		}
		
		else if(event.widget == btnRemove)
		{
			IStructuredSelection elem = (IStructuredSelection)tableViewer.getSelection();
			if(elem.size() > 0){
				Iterator i = elem.iterator();
				while(i.hasNext()){
					IReportDescription rptDesc = (IReportDescription)i.next();
					reportManager.removeReportDefinition(rptDesc);
					tableElements.remove(rptDesc);
				}
				
				tableViewer.refresh();				
			}
		
		}
		
		else if(event.widget == btnRename)
		{
			IStructuredSelection elem = (IStructuredSelection)tableViewer.getSelection();
			if(elem.size() > 0){
			
			    Object obj = elem.getFirstElement();
			    
				if(obj instanceof ReportDescription)
				{ 
					ReportDialog dlg = new ReportDialog(getShell(), (ReportDescription)obj);
					dlg.open();
					
					if(dlg.getReturnCode() == Window.OK)
					{				
						tableViewer.refresh();			
					}	
				}
			}		
		}
		
		else if(event.widget == btnTest)
		{
			IStructuredSelection elem = (IStructuredSelection)tableViewer.getSelection();
			if(elem.size() > 0){
				Iterator i = elem.iterator();
				while(i.hasNext()){
					
					Object obj = i.next();
					if(obj instanceof ReportDescription)
					{ 
						ReportDescription reportDescription = (ReportDescription)obj;
			
						try
						{
							if(reportDescription.getReportGenerator() != null)
							{
								String className = ""; //$NON-NLS-1$
								if(reportDescription.getClassName() != null)
									className = reportDescription.getClassName();
								String message = TestUIPlugin.getString("preferences.report.TestButton.Succeed", className); //$NON-NLS-1$
								
								MessageDialog.openInformation(getShell(), TestUIPlugin.getString("W_SUCCESS"), message); //$NON-NLS-1$
							}
							else
							{
									String className = ""; //$NON-NLS-1$
									if(reportDescription.getClassName() != null)
										className = reportDescription.getClassName();
									String message = TestUIPlugin.getString("preferences.report.TestButton.Fail.CantFind", className); //$NON-NLS-1$
							
									MessageDialog.openError(getShell(), TestUIPlugin.getString("W_ERROR"), message); //$NON-NLS-1$
							}
						}
						catch(ClassCastException e)
						{
							String className = ""; //$NON-NLS-1$
							if(reportDescription.getClassName() != null)
								className = reportDescription.getClassName();
							String message = TestUIPlugin.getString("preferences.report.TestButton.Fail.Instance", className); //$NON-NLS-1$
							
							MessageDialog.openError(getShell(), TestUIPlugin.getString("W_ERROR"), message); //$NON-NLS-1$
						}
						catch(Exception e)
						{
							String className = ""; //$NON-NLS-1$
							if(reportDescription.getClassName() != null)
								className = reportDescription.getClassName();
							String message = TestUIPlugin.getString("preferences.report.TestButton.Fail.CantFind", className); //$NON-NLS-1$
							
							MessageDialog.openError(getShell(), TestUIPlugin.getString("W_ERROR"), message); //$NON-NLS-1$
						}
						
					}
				}
			}
			
		}

		ISelection sel = tableViewer.getSelection();
		btnRename.setEnabled(false);
		btnRemove.setEnabled(false);
		btnTest.setEnabled(false);
		if ((sel != null) && sel instanceof StructuredSelection) {
			StructuredSelection selection  = (StructuredSelection)sel;
			ReportDescription reportDescription = (ReportDescription)selection.getFirstElement();
			if (reportDescription != null) {
				boolean isDefinedByPlugin = reportDescription.isDefinedByPlugin();
				btnRename.setEnabled(!isDefinedByPlugin);
				btnRemove.setEnabled(!isDefinedByPlugin);
				btnTest.setEnabled(true);
			}
		}
	}
	
	protected void openErrorMessageBox(String message)
	{
		
	}

	/**
	 * @see PreferencePage#computeSize()
	 */
	public Point computeSize() {
		Point p = super.computeSize();

		return p;
	}
	/**
	 * @see IWorkbenchPreferencePage#init(IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}
	/**
	 * @see PreferencePage#performDefaults()
	 */
	protected void performDefaults() {
		super.performDefaults();

	}
	/**
	 * @see PreferencePage#performOk()
	 */
	public boolean performOk() {
		reportManager.saveIntoPreferenceStore();
		return true;

	}

	/**
	 * Loads certificates from the key store.
	 */
	private void initializeValues() {
		IReportDescription[] list = reportManager.getReportDescriptions();
		for(int idx=0; idx<list.length; idx++)
			tableElements.add(list[idx]);
					
		tableViewer.setInput(tableElements);
	}
		
}
