/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class DatapoolCSVImportPage extends WizardPage implements ModifyListener, SelectionListener {

	private Button browseButton = null;
	private Button firstRowVarButton = null;
	private Button firstColEqClsButton = null;
	private Text csvFileText = null;
	
	/**
	 * @param pageName
	 */
	protected DatapoolCSVImportPage(String pageName) 
	{
		super(pageName);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) 
	{
        Composite mainComposite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		mainComposite.setLayout(layout);        
		Label label = new Label(mainComposite, SWT.NULL);
		label.setText(TestUIPlugin.getString("WIZ_DATAPOOL_CSV_PG_SEL"));

        Composite fileComposite = new Composite(mainComposite, SWT.NONE);        
		GridLayout fileLayout = new GridLayout();
		fileLayout = new GridLayout();
		fileLayout.numColumns = 2;
		fileLayout.marginHeight = 0;
		fileLayout.marginWidth = 0;
		fileLayout.makeColumnsEqualWidth = false;
		fileComposite.setLayout(fileLayout);
		GridData gridData = GridDataUtil.createHorizontalFill();
		fileComposite.setLayoutData(gridData);

		csvFileText = new Text(fileComposite, SWT.BORDER); 
		gridData = GridDataUtil.createHorizontalFill();
		gridData.widthHint = 300;
		csvFileText.setLayoutData(gridData);
		csvFileText.addModifyListener(this);
		browseButton = new Button(fileComposite, SWT.PUSH);
		browseButton.setText(TestUIPlugin.getString("BROWSE"));	
		browseButton.addSelectionListener(this);

        Composite optionComposite = new Composite(mainComposite, SWT.NONE);        
		GridLayout optionLayout = new GridLayout();
		optionLayout = new GridLayout();
		optionLayout.numColumns = 2;
		optionLayout.marginHeight = 0;
		optionLayout.marginWidth = 0;
		optionLayout.makeColumnsEqualWidth = false;
		optionComposite.setLayout(optionLayout);
		gridData = GridDataUtil.createHorizontalFill();
		optionComposite.setLayoutData(gridData);
		
		firstRowVarButton = new Button(optionComposite, SWT.CHECK);
		firstRowVarButton.setSelection(true);
		Label firstRowLabel = new Label(optionComposite, SWT.NULL);
		firstRowLabel.setText(TestUIPlugin.getString("WIZ_DATAPOOL_CSV_PG_COL_HEADER"));
		
		firstColEqClsButton = new Button (optionComposite, SWT.CHECK);
		firstColEqClsButton.setSelection(true);
		Label firstColLabel = new Label(optionComposite, SWT.NULL);
		firstColLabel.setText(TestUIPlugin.getString("WIZ_DATAPOOL_CSV_PG_ROW_HEADER"));
			
		setControl(mainComposite);
	}
	
	private String getCSVFileNameFromDialog()
	{
		FileDialog dialog = new FileDialog(getShell());
		dialog.setFilterExtensions(new String[] { "*.csv", "*.*" });
		dialog.setText(TestUIPlugin.getString("WIZ_DATAPOOL_CSV_PG_SEL"));
		if(csvFileText.getText().trim().length() > 0)
			dialog.setFilterPath(csvFileText.getText());
		
		String res = dialog.open();
		return res;
	}
	
	public String getCSVFileName()
	{
		return csvFileText.getText();
	}
	
	public boolean firstRowContainsVariableNameType()
	{
		return firstRowVarButton.getSelection();
	}
	
	public boolean firstColumnContainsEquivalenceClassName()
	{
		return firstColEqClsButton.getSelection();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e) 
	{
		if(csvFileText.getText().trim().length() > 0)
		{
			setPageComplete(true);
			getContainer().updateButtons();
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) 
	{
		String tempCSVFileName = getCSVFileNameFromDialog();
		if (tempCSVFileName != null)
		{
			csvFileText.setText(tempCSVFileName);
			setPageComplete(true);
			getContainer().updateButtons();
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) 
	{
		return;
	}


}
