/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.delegates;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.harness.TestExecutionHarness;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.launch.configurations.DeploymentLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.ExecutionHistoryLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;

/**
 * This class is the Delegate for the basic Hyades Launch Configuration.
 * It handles the launching of a Hyades Test according to a Hyades Launch Configuration.
 * @see ILaunchConfigurationDelegate
 * @author jcanches
 */
public class BasicTestLaunchConfigurationDelegate extends AbstractLaunchConfigurationDelegate {
	
    /**
     * Create a Hyades Basic Launch Configuration Delegate.
     */
    public BasicTestLaunchConfigurationDelegate() {
    }

    protected TPFTest getLaunchedTest(ILaunchConfiguration configuration) throws CoreException {
    	return TestLaunchConfigurationFacade.getTest(configuration);
    }
    
    protected TPFDeployment getDeployment(ILaunchConfiguration configuration) throws CoreException {
    	return DeploymentLaunchConfigurationFacade.getDeployment(configuration);
    }
    
    protected String getTestExecutionHistoryName(ILaunchConfiguration configuration) throws CoreException {
    	return ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryName(configuration);
    }
    
    protected IContainer getTestExecutionHistoryLocation(ILaunchConfiguration configuration) throws CoreException {
    	return ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryLocation(configuration);
    }   
    
	protected Object getLaunchedElement(ILaunchConfiguration configuration)	throws CoreException {
		return getLaunchedTest(configuration);
	}
	
    protected void validate(ILaunchConfiguration configuration, String mode) throws CoreException {
    	super.validate(configuration, mode);
   	
    	if (getDeployment(configuration) == null) {
			reportProblem("The configuration does not provide a Deployment"); //$NON-NLS-1$
		}
    	
    	String tehName = getTestExecutionHistoryName(configuration);
    	if (tehName == null || tehName.equals("")) { //$NON-NLS-1$
    		reportProblem("The configuration does not provide a Test Execution History Name"); //$NON-NLS-1$
    	}
    	
    	IContainer tehLocation = getTestExecutionHistoryLocation(configuration);
    	if (tehLocation == null) {
    		reportProblem("The configuration does not provide a Test Execution History Location"); //$NON-NLS-1$
    	} else if (!tehLocation.exists()) {
    		reportProblem("The Test Execution History Location described by the configuration does not exist"); //$NON-NLS-1$
    	}
    }
    
    /**
     * Launch a Hyades Test.
     * @see ILaunchConfigurationDelegate#launch
     */
    public IExecutor invokeTestExecutionHarness(ILaunchConfiguration configuration, String mode, StringBuffer errorMessages) throws CoreException {
		// Compute parameters
    	TPFTest test = getLaunchedTest(configuration);
    	TPFTestSuite testSuite = null;
    	TPFTest subTest = null;
    	if (test instanceof TPFTestCase) {
    		subTest = test;
    		testSuite = ((TPFTestCase)subTest).getTestSuite();
    	} else if (test instanceof TPFTestSuite) {
    		testSuite = (TPFTestSuite)test;
    		subTest = test;
    	}
    	
    	TPFDeployment deployment = getDeployment(configuration);	    	
    	String tehName = getTestExecutionHistoryName(configuration);
    	String tehLocation = getTestExecutionHistoryLocation(configuration).getFullPath().toString();
    	String port = TestUIPlugin.getInstance().getPreferenceStore().getString(TestUI.LOCALHOST_PORT);
    	
		TestExecutionHarness teh = new TestExecutionHarness();
		return teh.launchTest(
			(ITestSuite)testSuite,
			(ITest)subTest,
			deployment,
			port,
			tehLocation,
			tehName,
			true,
			false,
			errorMessages);
    }
    
}
