package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Taken from "Canonical Situation Data Format: The Common Base Event V1.0.1 
 * ACAB.BO0301.0.1"
 * 
 * In problem reporting there are two general categories of components that should be
 * considered for problem diagnosis, the component observing and reporting the situation
 * (reporter), and the actual component that is experiencing the situation (affected).
 * Component Identification provides a collection of attributes required to uniquely 
 * identify a component.  The same data is used to identify both the component that is
 * reporting an event or situation and the component that is affected or experiencing the
 * situation.  In some cases, these components will be the same. For example, in a typical
 * IT environment, commonly, the activities of applications running in that environment 
 * are often monitored using events received or collected from the applications via 
 * management agents or adapters. 
 * 
 * Example 1: Consider the case where a WebSphere application, called myWebApp, times out
 *            on a table query due to a DB2 server problem that is located on a remote 
 *            system.  The web app then issues an event indicating the failure situation.
 *            In this case, myWebApp is the 'affected' or the 'source' component.
 * 
 * Example 2: Consider a case where there is application X running on a Windows server.
 *            The application encounters an error and adds an entry to the Widows error
 *            log. Then there is a separate application (ie: an adapter) that reads
 *            messages from the error log and generates a common base event and submits
 *            it. In this case the  'affected' or the 'source' of the event is the
 *            application X and the reporting component is the adapter that generated and
 *            submitted the event.
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0
 */
public interface IComponentIdentification {

    /**
     * Well-known type for the '<em><b>Component Id Type</b></em>' attribute.
     * 
     * @see #getComponentIdType() 
     */
    static String COMPONENT_ID_TYPE_PRODUCT_NAME = "ProductName";

    /**
     * Well-known type for the '<em><b>Component Id Type</b></em>' attribute.
     * 
     * @see #getComponentIdType() 
     */
    static String COMPONENT_ID_TYPE_DEVICE_NAME = "DeviceName";

    /**
     * Well-known type for the '<em><b>Component Id Type</b></em>' attribute.
     * 
     * @see #getComponentIdType() 
     */
    static String COMPONENT_ID_TYPE_SYSTEM_NAME = "SystemName";

    /**
     * Well-known type for the '<em><b>Component Id Type</b></em>' attribute.
     * 
     * @see #getComponentIdType() 
     */
    static String COMPONENT_ID_TYPE_SERVICE_NAME = "ServiceName";

    /**
     * Well-known type for the '<em><b>Component Id Type</b></em>' attribute.
     * 
     * @see #getComponentIdType() 
     */
    static String COMPONENT_ID_TYPE_PROCESS = "Process";

    /**
     * Well-known type for the '<em><b>Component Id Type</b></em>' attribute.
     * 
     * @see #getComponentIdType() 
     */
    static String COMPONENT_ID_TYPE_APPLICATION = "Application";

    /**
     * Well-known type for the '<em><b>Component Id Type</b></em>' attribute.
     * 
     * @see #getComponentIdType() 
     */
    static String COMPONENT_ID_TYPE_UNKNOWN = "Unknown";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_UNKNOWN = "Unknown";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_IPV4 = "IPV4";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_IPV6 = "IPV6";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_NWA = "NWA";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_ISDN = "ISDN";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_ICD = "ICD";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_OID_OSI = "OID/OSI";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_DIAL = "Dial";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_HWA = "HWA";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_HID = "HID";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_X25 = "X25";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_DCC = "DCC";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_SNA = "SNA";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_IPX = "IPX";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_E_164 = "E.164";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_HOSTNAME = "Hostname";

    /**
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * 
     * @see #getLocationType() 
     */
    static String LOCATION_TYPE_FQ_HOSTNAME = "FQHostname";

    /**
    * Well-known type for the '<em><b>Location Type</b></em>' attribute.
    * 
    * @see #getLocationType() 
    */
    static String LOCATION_TYPE_DEVICE_NAME = "Devicename";

    /**
     * Returns the application.
     * 
     * The name of the application (e.g,  myWebApp).  This is an optional
     * property.  The application version information may be appended to 
     * the end of the component separated by a # character. This is an 
     * OPTIONAL property.  The maximum string length for the application
     * name MUST not exceed 255 bytes.
     * 
     * @return String
     */
    public String getApplication();

    /**
     * Returns the component.
     * 
     * Specifies the logical identity of a component. This property MUST
     * contain the name of a particular application, product, or subsystem
     * (e.g., IBM DB2# V7.1).  This value SHOULD be unique within the scope 
     * specified by the location. The component version information may be 
     * appended to the end of the component separated by a # character.
     * This is a REQUIRED property.  The maximum string length for the component
     * name MUST not exceed 255 bytes.
     * 
     * @return String
     */
    public String getComponent();

    /**
     * Returns the executionEnvironment.
     * 
     * This property identifies the immediate environment that an application
     * is running in.  For example, a WebSphere Application Server name: cell:node:server.
     * The executionEnvironment version information may be appended to the end
     * of the component separated by a # character. This is an OPTIONAL property.
     * The maximum string length for executionEnvironment MUST not exceed 255 bytes.
     * 
     * @return String
     */
    public String getExecutionEnvironment();

    /**
     * Returns the instanceId.
     * 
     * Specifies a handle or identifier for the instance of the component that
     * is specified by the component property i.e., Grid Service Handle(GSH)  
     * and EJBHandle. This is an OPTIONAL property.  The maximum string length
     * for instanceId MUST not exceed 128 bytes.
     * 
     * @return String
     */
    public String getInstanceId();

    /**
     * Returns the location.
     * 
     * Specifies the physical address corresponding to the location of a
     * component.  For example, hostname, IP address, or VTAM LU. The format
     * of the value of the location is specified by the locationType property.
     * The preferred value is a fully qualified hostname. This value should
     * be unique within the network capable of raising events to a specified
     * receiver. For example, if an adapter were monitoring a router, this
     * attribute would contain the IP address of the machine where the adapter
     * resides, not the IP address of the router that is having the problem.
     * This is a REQUIRED property.  The maximum string length for location
     * MUST not exceed 255 bytes.
     * 
     * @return String
     */
    public String getLocation();

    /**
     * Returns the locationType.
     * 
     * Specifies the format and meaning of the value in the location property.
     * The well-known reserved keywords for this property are: 
     * 1.  Unknown
     * 2.  IPV4
     * 3.  IPV6
     * 4.  NWA
     * 5.  ISDN
     * 6.  ICD
     * 7.  OID/OSI
     * 8.  Dial
     * 9.  HWA
     * 10. HID
     * 11. X25
     * 12. DCC
     * 13. SNA
     * 14. IPX
     * 15. E.164
     * 16. Hostname
     * 17. FQHostname
     * 18. Devicename 
     * This is a REQUIRED property.  The maximum string length for locationType 
     * MUST not exceed 32 bytes. The default value is 'Unknown'.
     * 
     * @return String
     */
    public String getLocationType();

    /**
     * Returns the processId.
     * 
     * This property identifies the process ID of the running component or subcomponent
     * that generated the event. This is an OPTIONAL property and there is no default 
     * value.  The maximum string length for processId MUST not exceed 64 bytes.
     * 
     * @return String
     */
    public String getProcessId();

    /**
     * Returns the subComponent.
     * 
     * Specifies a further delineation for the logical component property of 
     * the event.  It SHOULD contain the identity of the subcomponent of the 
     * component property.  This property can be one of the various parts of
     * an application or OS resource e.g., a module name, a class name, a class
     * and method name. It should be the most granular definition specified in
     * the event.  The subcomponent version information may be appended to the 
     * end of the subcomponent separated by a # character. This is a REQUIRED
     * property.  The maximum string length for the subComponent name MUST not
     * exceed 255 bytes.
     * 
     * @return String
     */
    public String getSubComponent();

    /**
     * Returns the threadId.
     * 
     * This property identifies the thread ID of the component or subcomponent
     * that generated the event.  This value changes with every new thread spawned
     * by the process identified by the processId. This is an OPTIONAL property and 
     * there is no default value.  The maximum string length for threadId MUST not
     * exceed 64 bytes.
     * 
     * @return String
     */
    public String getThreadId();

    /**
     * Sets the application.
     * 
     * The name of the application (e.g,  myWebApp).  This is an optional
     * property.  The application version information may be appended to 
     * the end of the component separated by a # character. This is an 
     * OPTIONAL property.  The maximum string length for the application
     * name MUST not exceed 255 bytes.
     * 
     * @param application The application to set
     */
    public void setApplication(String application);

    /**
     * Sets the component.
     * 
     * Specifies the logical identity of a component. This property MUST
     * contain the name of a particular application, product, or subsystem
     * (e.g., IBM DB2# V7.1).  This value SHOULD be unique within the scope 
     * specified by the location. The component version information may be 
     * appended to the end of the component separated by a # character.
     * This is a REQUIRED property.  The maximum string length for the component
     * name MUST not exceed 255 bytes.
     * 
     * @param component The component to set
     */
    public void setComponent(String component);

    /**
     * Sets the executionEnvironment.
     * 
     * This property identifies the immediate environment that an application
     * is running in.  For example, a WebSphere Application Server name: cell:node:server.
     * The executionEnvironment version information may be appended to the end
     * of the component separated by a # character. This is an OPTIONAL property.
     * The maximum string length for executionEnvironment MUST not exceed 255 bytes.
     * 
     * @param executionEnvironment The executionEnvironment to set
     */
    public void setExecutionEnvironment(String executionEnvironment);

    /**
     * Sets the instanceId.
     * 
     * Specifies a handle or identifier for the instance of the component that
     * is specified by the component property i.e., Grid Service Handle(GSH)  
     * and EJBHandle. This is an OPTIONAL property.  The maximum string length
     * for instanceId MUST not exceed 128 bytes.
     * 
     * @param instanceId The instanceId to set
     */
    public void setInstanceId(String instanceId);

    /**
     * Sets the location.
     * 
     * Specifies the physical address corresponding to the location of a
     * component.  For example, hostname, IP address, or VTAM LU. The format
     * of the value of the location is specified by the locationType property.
     * The preferred value is a fully qualified hostname. This value should
     * be unique within the network capable of raising events to a specified
     * receiver. For example, if an adapter were monitoring a router, this
     * attribute would contain the IP address of the machine where the adapter
     * resides, not the IP address of the router that is having the problem.
     * This is a REQUIRED property.  The maximum string length for location
     * MUST not exceed 255 bytes.
     * 
     * @param location The location to set
     */
    public void setLocation(String location);

    /**
     * Sets the locationType.
     * 
     * Specifies the format and meaning of the value in the location property.
     * The well-known reserved keywords for this property are: 
     * 1.  Unknown
     * 2.  IPV4
     * 3.  IPV6
     * 4.  NWA
     * 5.  ISDN
     * 6.  ICD
     * 7.  OID/OSI
     * 8.  Dial
     * 9.  HWA
     * 10. HID
     * 11. X25
     * 12. DCC
     * 13. SNA
     * 14. IPX
     * 15. E.164
     * 16. Hostname
     * 17. FQHostname
     * 18. Devicename 
     * This is a REQUIRED property.  The maximum string length for locationType 
     * MUST not exceed 32 bytes. The default value is 'Unknown'.
     * 
     * @param locationType The locationType to set
     */
    public void setLocationType(String locationType);

    /**
     * Sets the processId.
     * 
     * This property identifies the process ID of the running component or subcomponent
     * that generated the event. This is an OPTIONAL property and there is no default 
     * value.  The maximum string length for processId MUST not exceed 64 bytes.
     * 
     * @param processId The processId to set
     */
    public void setProcessId(String processId);

    /**
     * Sets the subComponent.
     * 
     * Specifies a further delineation for the logical component property of 
     * the event.  It SHOULD contain the identity of the subcomponent of the 
     * component property.  This property can be one of the various parts of
     * an application or OS resource e.g., a module name, a class name, a class
     * and method name. It should be the most granular definition specified in
     * the event.  The subcomponent version information may be appended to the 
     * end of the subcomponent separated by a # character. This is a REQUIRED
     * property.  The maximum string length for the subComponent name MUST not
     * exceed 255 bytes.
     * 
     * @param subComponent The subComponent to set
     */
    public void setSubComponent(String subComponent);

    /**
     * Sets the threadId.
     * 
     * This property identifies the thread ID of the component or subcomponent
     * that generated the event.  This value changes with every new thread spawned
     * by the process identified by the processId. This is an OPTIONAL property and 
     * there is no default value.  The maximum string length for threadId MUST not
     * exceed 64 bytes.
     * 
     * @param threadId The threadId to set
     */
    public void setThreadId(String threadId);

    /**
     * Returns the componentIdType.
     * 
     * Specifies the format and meaning of the component identified by this
     * componentIdentification. The nonexclusive reserved keywords for this 
     * property are:
     * 1. ProductName
     * 2. DeviceName
     * 3. SystemName
     * 4. ServiceName
     * 5. Process
     * 6. Application 
     * 7. Unknown
     * This is a REQUIRED property.  The maximum string length for componentIdType
     * MUST not exceed 32 bytes. The default value is 'Unknown'.
     * 
     * @return String
     */
    public String getComponentIdType();

    /**
     * Sets the componentIdType.
     * 
     * Specifies the format and meaning of the component identified by this
     * componentIdentification. The nonexclusive reserved keywords for this 
     * property are:
     * 1. ProductName
     * 2. DeviceName
     * 3. SystemName
     * 4. ServiceName
     * 5. Process
     * 6. Application 
     * 7. Unknown
     * This is a REQUIRED property.  The maximum string length for componentIdType
     * MUST not exceed 32 bytes. The default value is 'Unknown'.
     * 
     * @param componentIdType The componentIdType to set
     */
    public void setComponentIdType(String componentIdType);

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     */
    public void init();

    /**
     * Sets the componentType.
     * 
     * The componentType is a well-defined name that is used to characterize all 
     * instances of a given kind of component.  
     * This property is REQUIRED property. 
     * The maximum string length for componentType MUST NOT exceed 512 characters.   
     * 
     * @param componentType The componentType to be set.
     * @since 1.0.1
     */
    public void setComponentType(String componentType);

    /**
     * Returns the componentType.
     * 
     * The componentType is a well-defined name that is used to characterize all 
     * instances of a given kind of component.  
     * This property is REQUIRED property. 
     * The maximum string length for componentType MUST NOT exceed 512 characters.   
     * 
     * @return String The returned componentType.
     * @since 1.0.1
     */
    public String getComponentType();
}
