package org.eclipse.hyades.logging.events;

import java.util.List;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * @author rduggan
 *
 * Taken from "Canonical Situation Data Format: The Common Base Event V1.0.1 
 * ACAB.BO0301.0.1"
 *
 * This MsgDataElementImpl represents the data that is used to specify all the related 
 * information associated with the message that this event holds.
 * 
 * @version 1.0.1
 * @since 1.0
 */
public interface IMsgDataElement {

    /**
     * Returns the msgCatalog
     * 
     * The qualified name of the message catalog that contains the translated message
     * specified by the msgCatalogId. This is an OPTIONAL property.  The maximum string
     * length of the msgCatalog MUST not exceed 128 bytes.
     * 
     * @return String
     */
    public String getMsgCatalog();

    /**
     * Returns the msgCatalogId.
     * 
     * The index or the identifier for a message that is used for resolving the message
     * text from a message catalog. This is an OPTIONAL property.  
     * 
     * @return String
     */
    public String getMsgCatalogId();

    /**
     * Returns the msgCatalogTokens.
     * 
     * An array of IMsgCatalogTokens used as substitution values for resolving a NLS based message
     * into formatted text.  The order of the substitution values is implied by the 
     * implicit order of the array elements. If there are no substitution values, then
     * it does not need to be specified. This is an OPTIONAL property.  The maximum 
     * string length of the msgCatalogTokens property MUST not exceed 255 bytes.
     * 
     * @return List of Message Catalog Tokens, otherwise an empty list.
     */
    public List getMsgCatalogTokens();
    
    /**
     * Returns the msgCatalogTokens.
     * 
     * An array of strings used as substitution values for resolving a NLS based message
     * into formatted text.  The order of the substitution values is implied by the 
     * implicit order of the array elements. If there are no substitution values, then
     * it does not need to be specified. This is an OPTIONAL property.  The maximum 
     * string length of the msgCatalogTokens property MUST not exceed 255 bytes.
     * 
     * @return String[]
     */
    public String[] getMsgCatalogTokensAsStrings();

    /**
     * Removes all IMsgCatalogToken that this event is referencing 
     */
    public void clearMsgCatalogTokens();

    /**
     * Adds a new MsgCatalogToken to this object.
     */
    public void addMsgCatalogToken(IMsgCatalogToken value);

    /**
     * Adds a new MsgCatalogToken to this object.
     */
    public IMsgCatalogToken addMsgCatalogTokenAsString(String value);

    /**
     * Returns the msgId.
     * 
     * Specifies the message identifier of the event. This identifier is commonly a 
     * unique value string of alphanumeric or numeric characters. It can be as simple
     * as a string of numeric characters identifying a message in a message catalog or
     * a multi-part string of alphanumeric characters (e.g., DBT1234E). 
     * This is a REQUIRED property.  The maximum string length for msgId MUST not 
     * exceed 255 bytes.
     * 
     * @return String
     */
    public String getMsgId();

    /**
     * Returns the msgIdType.
     * 
     * Specifies the meaning and format of the msgId. If the ID conforms to or represents 
     * a standard or a well-known convention, it is named by this property.   Examples 
     * are: IBM3.4, IBM4.4, IBM3.1.4, IBM3.4.1, IBM4.4.1, and IBM3.1.4.1.  
     * The current nonexclusive list of reserved keywords include:
     * 1. IBM
     * 2. JMX
     * 3. DottedName
     * 4. Unknown
     * This is a REQUIRED property.  The maximum string length for msgId MUST not exceed 
     * 32 bytes.
     * 
     * @return String
     */
    public String getMsgIdType();

    /**
     * Returns the msgLocale.
     * 
     * The locale by which this msg property is rendered.  Its value is a locale code in
     * conformance with ISO/IEC 639.1 language code and ISO/IEC 3166 country code. This
     * is an OPTIONAL property.  The maximum string length of the msgLocale MUST not 
     * exceed 5 bytes.
     * 
     * @return String
     */
    public String getMsgLocale();

    /**
     * Returns the msgCatalogType.
     * 
     * @return String
     */
    public String getMsgCatalogType();

    /**
     * Sets the msgCatalog.
     * 
     * The qualified name of the message catalog that contains the translated message
     * specified by the msgCatalogId. This is an OPTIONAL property.  The maximum string
     * length of the msgCatalog MUST not exceed 128 bytes.
     * 
     * @param msgCatalog The msgCatalog to set
     */
    public void setMsgCatalog(String msgCatalog);

    /**
     * Sets the msgCatalogId.
     * 
     * The index or the identifier for a message that is used for resolving the message
     * text from a message catalog. This is an OPTIONAL property.  
     * 
     * @param msgCatalogId The msgCatalogId to set
     */
    public void setMsgCatalogId(String msgCatalogId);

    /**
     * Sets the msgCatalogTokens.
     * 
     * An array of strings used as substitution values for resolving a NLS based message
     * into formatted text.  The order of the substitution values is implied by the 
     * implicit order of the array elements. If there are no substitution values, then
     * it does not need to be specified. This is an OPTIONAL property.  The maximum 
     * string length of the msgCatalogTokens property MUST not exceed 255 bytes.
     * 
     * @param msgCatalogTokens The msgCatalogTokens to set
     */
    public void setMsgCatalogTokensAsStrings(String[] msgCatalogTokenArray);

    /**
     * Sets the msgCatalogTokens.
     * 
     * An array of IMsgCatalogTokens used as substitution values for resolving a NLS based message
     * into formatted text.  The order of the substitution values is implied by the 
     * implicit order of the array elements. If there are no substitution values, then
     * it does not need to be specified. This is an OPTIONAL property.  The maximum 
     * string length of the msgCatalogTokens property MUST not exceed 255 bytes.
     * 
     * @param msgCatalogTokens The msgCatalogTokens to set
     */
    public void setMsgCatalogTokens(IMsgCatalogToken[] msgCatalogTokenArray);

    /**
     * Sets the msgId.
     * 
     * Specifies the message identifier of the event. This identifier is commonly a 
     * unique value string of alphanumeric or numeric characters. It can be as simple
     * as a string of numeric characters identifying a message in a message catalog or
     * a multi-part string of alphanumeric characters (e.g., DBT1234E). 
     * This is a REQUIRED property.  The maximum string length for msgId MUST not 
     * exceed 255 bytes.
     * 
     * @param msgId The msgId to set
     */
    public void setMsgId(String msgId);

    /**
     * Sets the msgIdType.
     * 
     * Specifies the meaning and format of the msgId. If the ID conforms to or represents 
     * a standard or a well-known convention, it is named by this property.   Examples 
     * are: IBM3.4, IBM4.4, IBM3.1.4, IBM3.4.1, IBM4.4.1, and IBM3.1.4.1.  
     * The current nonexclusive list of reserved keywords include:
     * 1. IBM
     * 2. JMX
     * 3. DottedName
     * 4. Unknown
     * This is a REQUIRED property.  The maximum string length for msgId MUST not exceed 
     * 32 bytes.
     * 
     * @param msgIdType The msgIdType to set
     */
    public void setMsgIdType(String msgIdType);

    /**
     * Sets the msgLocale.
     * 
     * The locale by which this msg property is rendered.  Its value is a locale code in
     * conformance with ISO/IEC 639.1 language code and ISO/IEC 3166 country code. This
     * is an OPTIONAL property.  The maximum string length of the msgLocale MUST not 
     * exceed 5 bytes.
     * 
     * @param msgLocale The msgLocale to set
     */
    public void setMsgLocale(String msgLocale);

    /**
     * Sets the msgCatalogType.
     * 
     * @param msgCatalogType The msgCatalogType to set
     */
    public void setMsgCatalogType(String msgCatalogType);

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     */
    public void init();
}
