package org.eclipse.hyades.logging.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Taken from "Canonical Situation Data Format: The Common Base Event V1.0.1 
 * ACAB.BO0301.0.1"
 * 
 * This MsgDataElement represents the data that is used to specify all of the 
 * related information that is associated with the message that this event holds.
 * 
 * @author rduggan
 * @version 1.0.1
 * @since 1.0
 */
public class MsgDataElementImpl implements IMsgDataElement, Serializable, Cloneable {

    //define the serialiVersionUID for serialization
    //if this object is ever changed that breaks backward compatability
    //this value MUST be changed Every effort should be made not to
    //break backward compatability
    static final long serialVersionUID = 7867235418948277653L;

    // define the fields that will be serialized. 
    // if any new variables are added to the class
    // this table should be updated along with the readObject and writeObject methods    
    private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("msgId", String.class), new ObjectStreamField("msgIdType", String.class), new ObjectStreamField("msgCatalogId", String.class), new ObjectStreamField("msgCatalog", String.class), new ObjectStreamField("msgLocale", String.class), new ObjectStreamField("msgCatalogType", String.class), new ObjectStreamField("msgCatalogTokens", IMsgCatalogToken[].class), };

    /**
     * Fields.
     */
    protected String msgId = null;
    protected String msgIdType = null;
    protected String msgCatalogId = null;
    protected String msgCatalog = null;
    protected String msgLocale = null;
    protected String msgCatalogType = null;
    protected ArrayList msgCatalogTokens = null;

    /**
     * Constructor for MsgDataElementImpl.
     */
    protected MsgDataElementImpl() {
        super();
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#getMsgCatalog()
     */
    public String getMsgCatalog() {
        return msgCatalog;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#getMsgCatalogId()
     */
    public String getMsgCatalogId() {
        return msgCatalogId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#getMsgCatalogTokens()
     */
    public List getMsgCatalogTokens() {
       
		if (msgCatalogTokens == null) {
			msgCatalogTokens = new ArrayList();
		}

		return msgCatalogTokens;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#getMsgCatalogTokensAsStrings()
     */
    public String[] getMsgCatalogTokensAsStrings() {

        if (msgCatalogTokens != null) {

            String[] msgCatalogTokensAsStrings = new String[msgCatalogTokens.size()];

            for (int counter = 0; counter < msgCatalogTokens.size(); counter++) {
                msgCatalogTokensAsStrings[counter] = ((IMsgCatalogToken) (msgCatalogTokens.get(counter))).getValue();
            }

            return msgCatalogTokensAsStrings;
        }

        return null;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#clearMsgCatalogTokens()
     */
    public void clearMsgCatalogTokens() {
        msgCatalogTokens = null;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#getMsgId()
     */
    public String getMsgId() {
        return msgId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#getMsgIdType()
     */
    public String getMsgIdType() {
        return msgIdType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#getMsgLocale()
     */
    public String getMsgLocale() {
        return msgLocale;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#getMsgCatalogType()
     */
    public String getMsgCatalogType() {
        return msgCatalogType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#setMsgCatalog(String)
     */
    public void setMsgCatalog(String msgCatalog) {
        this.msgCatalog = msgCatalog;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#setMsgCatalogId(String)
     */
    public void setMsgCatalogId(String msgCatalogId) {
        this.msgCatalogId = msgCatalogId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#setMsgCatalogTokensAsStrings(String[])
     */
    public void setMsgCatalogTokensAsStrings(String[] msgCatalogTokenArray) {

        clearMsgCatalogTokens();

        if (msgCatalogTokenArray != null) {

            for (int counter = 0; counter < msgCatalogTokenArray.length; counter++) {
                addMsgCatalogTokenAsString(msgCatalogTokenArray[counter]);
            }
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#setMsgCatalogTokens(IMsgCatalogToken[])
     */
    public void setMsgCatalogTokens(IMsgCatalogToken[] msgCatalogTokenArray) {

        clearMsgCatalogTokens();

        if (msgCatalogTokenArray != null) {

            for (int counter = 0; counter < msgCatalogTokenArray.length; counter++) {
                addMsgCatalogToken(msgCatalogTokenArray[counter]);
            }
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#addMsgCatalogToken(org.eclipse.hyades.logging.events.IMsgCatalogToken)
     */
    public void addMsgCatalogToken(IMsgCatalogToken value) {

        if (msgCatalogTokens == null) {
            msgCatalogTokens = new ArrayList();
        }

        msgCatalogTokens.add(value);
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#addMsgCatalogTokenAsString(java.lang.String)
     */
    public IMsgCatalogToken addMsgCatalogTokenAsString(String value) {

        IMsgCatalogToken msgCatalogToken = new MsgCatalogTokenImpl();
        msgCatalogToken.setValue(value);

        addMsgCatalogToken(msgCatalogToken);

        return msgCatalogToken;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#setMsgId(String)
     */
    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#setMsgIdType(String)
     */
    public void setMsgIdType(String msgIdType) {
        this.msgIdType = msgIdType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#setMsgLocale(String)
     */
    public void setMsgLocale(String msgLocale) {
        this.msgLocale = msgLocale;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#setMsgCatalogType(String)
     */
    public void setMsgCatalogType(String msgCatalogType) {
        this.msgCatalogType = msgCatalogType;
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#init()
     */
    public void init() {

        msgCatalogTokens = null;
        msgId = null;
        msgIdType = null;
        msgCatalogId = null;
        msgCatalog = null;
        msgLocale = null;
        msgCatalogType = null;
    }

    /**
     * Determines is two different objects are equal.
     */
    public boolean equals(Object obj) {

        //It's the same object reference, so it HAS to be equal
        if (this == obj) {
            return false;
        }
        else {
            //If the object is null or is not the correct type of object, it can't be
            //equal
            if ((obj != null) && (obj instanceof MsgDataElementImpl) && (getClass() == obj.getClass())) {
                MsgDataElementImpl msgDataElement = (MsgDataElementImpl) obj;

                Object property1;
                Object property2;

                property1 = getMsgId();
                property2 = msgDataElement.getMsgId();

                if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                    property1 = getMsgIdType();
                    property2 = msgDataElement.getMsgIdType();

                    if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                        property1 = getMsgCatalogId();
                        property2 = msgDataElement.getMsgCatalogId();

                        if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                            property1 = getMsgCatalog();
                            property2 = msgDataElement.getMsgCatalog();

                            if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                                property1 = getMsgLocale();
                                property2 = msgDataElement.getMsgLocale();

                                if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                                    property1 = getMsgCatalogType();
                                    property2 = msgDataElement.getMsgCatalogType();

                                    if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {

                                        if (((msgCatalogTokens != null) && (msgCatalogTokens.equals(msgDataElement.msgCatalogTokens))) || (((msgCatalogTokens == null) || (msgCatalogTokens.size() == 0)) && ((msgDataElement.msgCatalogTokens == null) || (msgDataElement.msgCatalogTokens.size() == 0)))) {

                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        // set the values of the Serializable fields
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("msgId", msgId);
        fields.put("msgIdType", msgIdType);
        fields.put("msgCatalogId", msgCatalogId);
        fields.put("msgCatalog", msgCatalog);
        fields.put("msgLocale", msgLocale);
        fields.put("msgCatalogType", msgCatalogType);

        if ((msgCatalogTokens != null) && (!msgCatalogTokens.isEmpty())) {
            fields.put("msgCatalogTokens", ((IMsgCatalogToken[]) (msgCatalogTokens.toArray(new IMsgCatalogToken[msgCatalogTokens.size()]))));
        }

        // save them
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        // prepare to read the alternate persistent fields
        ObjectInputStream.GetField fields = null;
        fields = in.readFields();

        // read the alternate persistent fields
        msgId = (String) fields.get("msgId", msgId);
        msgIdType = (String) fields.get("msgIdType", msgIdType);
        msgCatalogId = (String) fields.get("msgCatalogId", msgCatalogId);
        msgCatalog = (String) fields.get("msgCatalog", msgCatalog);
        msgLocale = (String) fields.get("msgLocale", msgLocale);
        msgCatalogType = (String) fields.get("msgCatalogType", msgCatalogType);

        msgCatalogTokens = new ArrayList();

        Object tempArray[] = ((Object[]) (fields.get("msgCatalogTokens", null)));

        if (tempArray != null) {

            for (int counter = 0; counter < tempArray.length; counter++) {
                addMsgCatalogToken((IMsgCatalogToken) tempArray[counter]);
            }
        }
    }

    /**
     * return a cloned (copy by value) object. This is a deep copy version, in which all the
     * objects within this object will be copied by value.
     *  
     * @return Object
     */
    public Object clone() throws CloneNotSupportedException {

        MsgDataElementImpl copy = ((MsgDataElementImpl) (super.clone()));

        //Clone the msgCatalogTokens array list:
        if (this.msgCatalogTokens != null) {

            copy.msgCatalogTokens = ((ArrayList) (this.msgCatalogTokens.clone()));

            for (int counter = 0; counter < this.msgCatalogTokens.size(); counter++) {

                Object tempElement = msgCatalogTokens.get(counter);

                /* if the Elements in msgCatalogTokens arrayList are some other implementations,
                 * it will only be shallow cloned.
                 */
                if (tempElement instanceof MsgCatalogTokenImpl) {
                    copy.msgCatalogTokens.set(counter, ((IMsgCatalogToken) ((MsgCatalogTokenImpl) (tempElement)).clone()));
                }
            }
        }

        return copy;
    }
}
