package org.eclipse.hyades.logging.java;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.util.logging.Filter;
import java.util.logging.LogRecord;

/** 
 * Implementation of the Java Logging <code>java.util.logging.Filter</code>
 * interface used to provide control over what is logged at a more 
 * granular level than logging level for both <code>java.util.logging.Logger</code>s 
 * and <code>java.util.logging.Handler</code>s.
 * <p>
 * Only <code>org.eclipse.hyades.logging.java.CommonBaseEventLogRecord</code>
 * types of <code>java.util.logging.LogRecord</code>s are logged when this 
 * filter is utilized.
 * <p>
 * An instance of this class will be returned from the <code>getFilter()</code> APIs on 
 * the <code>java.util.logging.Logger</code>s and/or runtime <code>java.util.logging.Handler</code>s.  
 * The default <code>java.util.logging.LogManager</code> implementation
 * uses the following configuration variable in the default <JRE V1.4.0>/lib/logging.properties configuration
 * file to load configuration for <code>java.util.logging.Logger</code>s and/or 
 * runtime <code>java.util.logging.Handler</code>s:
 * <p>
 * <logger and/or handler name>.filter = org.eclipse.hyades.logging.java.CommonBaseEventFilter
 * <p>
 * Alternatively, an instantiation of this filter class may be set directly to <code>java.util.logging.Logger</code>s 
 * and/or runtime <code>java.util.logging.Handler</code>s by using the <code>setFilter()</code> APIs.
 * <p>
 * NOTE:  The Java Logging classes (e.g. JDK V1.4.0 and above) must be on the CLASSPATH at runtime to utilize this filter class
 *  
 * 
 * @author		Paul Slauenwhite
 * @version	March 7, 2003
 * @see		java.util.logging.Filter
 * @see		java.util.logging.LogRecord
 * @see		org.eclipse.hyades.logging.java.CommonBaseEventLogRecord
 */

public class CommonBaseEventFilter implements Filter {

    /**
     * Checks if the parameter <code>java.util.logging.LogRecord</code> is loggable.  To 
     * be loggable, the parameter <code>java.util.logging.LogRecord</code> must be an 
     * instance of <code>org.eclipse.hyades.logging.java.CommonBaseEventLogRecord</code>.
     * 
     * @param logRecord The <code>java.util.logging.LogRecord</code> to be checked if it is loggable.
     * @return True if the parameter <code>java.util.logging.LogRecord</code> is an instance of <code>org.eclipse.hyades.logging.java.CommonBaseEventLogRecord</code>.
     */
    public boolean isLoggable(LogRecord logRecord) {
        return (logRecord instanceof CommonBaseEventLogRecord);
    }
}
