package httpRecorder.proxy;

/*
 * Disclaimer:
 * The following source code is sample code created by IBM Corporation. 
 * This sample code is not part of any standard IBM product and is provided 
 * to you solely for the purpose of assisting you in the development of your 
 * applications. The code is provided 'AS IS', without warranty or condition 
 * of any kind. IBM shall not be liable for any damages arising out of your 
 * use of the sample code, even if IBM has been advised of the possibility of 
 * such damages.
 */

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/**
 * The request is the object that stores the data that is
 * sent from the client (usually a browser) to the server.
 */ 
public class HttpRequest
extends HttpElement
{
	private String method;
	private String host;
	private int port;
	private String absolutePath;
	
	private HttpResponse response;
	
	public HttpRequest()
	{
		super();
		port = 80;		
	}
	
	protected void setBody(InputStream inputStream)
	throws IOException
	{
		int contentLength = getHeaderIntValue(IHttpHeaderName.CONTENT_LENGTH);
		if(contentLength <= 0)
			return;
		
		int available = inputStream.available();
		if(available < contentLength)
			available = contentLength;
		
		byte[] body = new byte[available];
		inputStream.read(body);
		
		setBody(body);
	}

	protected void parse()
	throws IOException
	{
		String line = super.getLine();
		String token = " ";
		int index = line.indexOf(token);
		if(index < 0)
			return;
			
		method = line.substring(0, index);
		
		int pos = index+token.length();
		index = line.indexOf(token, pos);
		if(index < 0)
			return;
			
		String uri = line.substring(pos, index);
		URL url = new URL(uri);
		host = url.getHost();
		absolutePath = url.getFile();
		port = url.getPort();
		if(port == -1)
			port = 80;
			
		pos = index+token.length();
		if(pos < line.length())
			setVersion(line.substring(pos));
	}
	
	public String getMethod()
	{
		return method;
	}

	public String getHost()
	{
		return host;
	}

	public int getPort()
	{
		return port;
	}

	public String getAbsolutePath()
	{
		return absolutePath;
	}
	
	public String getLine()
	{
		return method + " " + absolutePath + " " + getVersion();
	}
	
	protected StringBuffer xmlAttributes()
	{
		StringBuffer attributes = new StringBuffer();
		attributes.append(ProxyUtil.xmlAttribute("method", getMethod()));
		attributes.append(ProxyUtil.xmlAttribute("host", getHost()));
		attributes.append(ProxyUtil.xmlAttribute("port", Integer.toString(getPort())));
		attributes.append(ProxyUtil.xmlAttribute("abs_path", getAbsolutePath()));
		if(getResponse() != null)
			attributes.append(ProxyUtil.xmlAttribute("responseCreationTime", Long.toString(getResponse().getCreationTime())));

		attributes.append(super.xmlAttributes());
		
		return attributes;
	}

	protected String xmlTopElement()
	{
		return "request";
	}
	
	public HttpResponse getResponse()
	{
		return response;
	}

	/**
	 * All the verification to enforce the bidirectional association
	 * must be done by the caller of this method
	 */
	void setResponse(HttpResponse response)
	{
		this.response = response;
	}
}
