/*
 * Created on Mar 17, 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.eclipse.hyades.test.common.runner;

import java.util.HashMap;
import java.util.StringTokenizer;

import org.eclipse.hyades.execution.core.IControlMessage;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.remote.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;
import org.eclipse.hyades.test.common.agent.ComptestAgent;
import org.eclipse.hyades.test.common.event.ExecutionEvent;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceFactoryImpl;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofilePackageImpl;


/**
 * @author jsutton
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class HyadesRunner {

	private boolean isOKToStart = false;
	protected ComptestAgent comptestAgent;
	protected RemoteComponentSkeleton agent;
	public HashMap agentCollection = new HashMap();

	public class Commandhandler implements CustomCommandHandler 
	{
		public void handleCommand(CustomCommand command) 
		{
			String cmd = command.getData();
			
			if (cmd.equals(IControlMessage.START)) 
			{
				setOKToStart(true);
			} 
			else if(cmd.startsWith("AgentIDs:"))
			{
				String dpString = new String(command.getDataBinary());
				dpString = dpString.substring(dpString.indexOf(':')+1,dpString.length());
				StringTokenizer dpTokenizer = new StringTokenizer(dpString,",");
				while(dpTokenizer.hasMoreTokens())
				{
					String id = dpTokenizer.nextToken();
					RemoteComponentSkeleton agent = new RemoteComponentSkeleton("Executor$" + id, "tester");
					agent.addCommandListener
					(
						new CustomCommandHandler()
						{
							public void handleCommand(CustomCommand command) 
							{
								String cmd = command.getData();
							}
						}
					);
					try
					{
						agent.initialize();
						agentCollection.put(id,agent);
					}
					catch (AgentControllerUnavailableException e)
					{
						e.printStackTrace();
					}
				
				}
			}
			else 
			{
					handleCustomCommand(command);
			}
		}
	}

	/**
	 * Is it okay to continue starting the test?
	 * @return <code>true</code> if it is okay to start the test,
	 * <code>false</code> otherwise
	 */
	public synchronized boolean isOKToStart()
	{
		return isOKToStart;
	}

	// Set the "okay to start" flag and notify any threads that are waiting
	// on this object's monitor.
	protected synchronized void setOKToStart(boolean isOK)
	{
		isOKToStart = isOK;
		notifyAll();
	}


	public HyadesRunner() {
		super();
	}
	
	public HyadesRunner(String args[]) {
		super();
		
		// waitForDebugger(true);
		
		//Initialize EMF models for datapools
		Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("datapool", new FacadeResourceFactoryImpl()); 
	    Common_TestprofilePackageImpl.init();		
					
		/* Create our agent */
		agent = new RemoteComponentSkeleton("Executor$" + args[args.length-1], "tester");
		
		comptestAgent = new ComptestAgent(agent);
		
		// Add a command listener that can okay the starting of the test.
		agent.addCommandListener(new Commandhandler());

		/* Handshake with the Agent controller */
		try
		{
			agent.initialize();
		}
		catch (Throwable e)
		{
		}
		
		/* Wait for our start.  We will never wait more that 3 minutes */
		while (!isOKToStart())
		{
			synchronized (this)
			{
				try
				{
					wait(3 * 60000);
					if (!isOKToStart())
					{
						/* Try and tell the client we are timing out */
						agent.sendMessageToAttachedClient("Test was not started after 3 minutes.  Exiting testcase.", 0);

						/* We have timed out.  exit */
						System.exit(-1);

					}
				}
				catch (InterruptedException e)
				{

				}
			}
		}
	}
	
	public void handleCustomCommand(CustomCommand command) {}
	
	public void writeExecEvent(ExecutionEvent executionEvent)
	{
		if((comptestAgent != null) && (executionEvent != null))
			comptestAgent.write(executionEvent.toString());
	}

	public void writeExecEvent(String executionEventStr)
	{
		if((comptestAgent != null) && (executionEventStr != null))
			comptestAgent.write(executionEventStr);
	}
	/**
	 * @param key
	 * @return
	 */
	public RemoteComponentSkeleton getAgent(Object key)
	{
		if(key==null)
			return agent;
		return (RemoteComponentSkeleton)agentCollection.get(key);
	}

}
