/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;


/**
 * @author slavescu
 */
public interface IXMLLoader {
    //~ Methods ------------------------------------------------------------------------------------

    public abstract void setCollectionMode(int collectionMode);

    public abstract HierarchyContext getContext();

    public abstract int getProcessedFragments();

    public abstract void attributeName(String name);

    public abstract void attributeValueCharacters(String attributeValue);

    public abstract void characters(char[] ch, int start, int length);

    public abstract void cleanUp();

    public abstract void endDocument(Object object, int i);

    public abstract void endElement(String elementName, int currentOffset);

    public abstract void error(InvalidXMLException exception);

    public abstract void loadEvent(byte[] buffer, int length, boolean loadToModel, boolean toProfileFile) throws InvalidXMLException;

    public abstract void loadEvent(byte[] buffer, int length, boolean loadToModel) throws InvalidXMLException;

    public abstract void loadEvent(byte[] buffer, int length) throws InvalidXMLException;

    public abstract void restartParser();

    public abstract void startDocument();

    public abstract void startElement(String elementName, boolean hasAttributes, boolean isEmpty);
}
