/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

public interface XMLFragmentLoader {
    //~ Methods ------------------------------------------------------------------------------------

    void addAttribute(String name, String value);

    void addCharacters(char[] data, int offset, int length);

    /**
     * This is called on end of root element of each fragment
     */
    void addYourselfInContext();

    /**
     * This is called at the end of the document.
     */
    void cleanUp();

    void endChild(String name);

    /**
     * This is called on start of root element of each fragment
     */
    void initialize(HierarchyContext context, String name);

    void startChild(String name);
}
