/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * @author slavescu
 */
public class ContainmentTraverser extends EObjectsTraverser {
	private boolean resolve;

	private ChildrenListPool childrenPool;

	public static final class ChildrenListPool {
		private ArrayList lists = new ArrayList(20);
		private int currentEntryIndex = -1;

		public ChildrenListPool() {
			super();
		}

		public List alloc() {
			List list;
			if (lists.size() == (currentEntryIndex + 1)) {
				list = new FastList();
				lists.add(list);
				currentEntryIndex++;
			} else {
				currentEntryIndex++;
				list = (List) lists.get(currentEntryIndex);
			}

			return list;
		}

		public void release(List children) {
			children.clear();
			currentEntryIndex--;
		}
	}

	/**
	 * @param contents
	 */
	public ContainmentTraverser(Collection contents) {
		super(contents);
		resolve = true;
		childrenPool = new ChildrenListPool();
	}
	public ContainmentTraverser(Collection contents, boolean resolve) {
		super(contents);
		this.resolve = resolve;
		childrenPool = new ChildrenListPool();
	}

	protected boolean traverseEObject(EObject object) {
		List children = childrenPool.alloc();
		populateChildren(object, children);
		boolean res = traverse(children);
		childrenPool.release(children);
		return res;
	}

	/**
	 * @return
	 */
	private void populateChildren(EObject parent, List children) {
		List features = parent.eClass().getEAllContainments();
		for (int i = features.size() - 1; i >= 0; i--) {
			EStructuralFeature sf = (EStructuralFeature) features.get(i);
			if (parent.eIsSet(sf)) {
				Object result = parent.eGet(sf, resolve);
				if (result instanceof EList) {
					for (Iterator iter2 = getIterator((EList) result); iter2.hasNext();) {
						EObject element = (EObject) iter2.next();
						if (element != null)
							children.add(element);
					}
				} else if (result != null)
					children.add(result);
			}
		}
	}

	protected Iterator getIterator(EList result) {
		if (resolve)
			return result.iterator();
		else
			return ((InternalEList) result).basicIterator();
	}

	protected EObject getElement(EObject traversedElement) {
		return traversedElement;
	}
}
