/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.logc.internal.actions;

import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogAsyncMessage;
import org.eclipse.hyades.sd.logc.internal.uml2sd.SourceOutOfPageMessage;
import org.eclipse.hyades.sd.logc.internal.util.GraphNodeSelectionDialog;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class GoToSource implements IObjectActionDelegate {

	private SDView view;
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		LogInteractions loader = (LogInteractions)LoadersManager.getLoadersManager().getCurrentLoader();
		if(view!=null){
			ISelection selection = view.getSDWidget().getSelectionProvider().getSelection();
			if(selection!=null && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size()>0){		
				Object sel = ((IStructuredSelection)selection).getFirstElement();
				if(sel instanceof SourceOutOfPageMessage){
					if(((SourceOutOfPageMessage)sel).getSource().size()>1){	
						GraphNodeSelectionDialog dialog = new GraphNodeSelectionDialog(view.getSDWidget().getShell(), GraphNodeSelectionDialog.SOURCE_EVENTS);
						dialog.setInput(((SourceOutOfPageMessage)sel).getSource());					
						if(dialog.open()==Window.OK){ 
							loader.setSelection((CBECommonBaseEvent)dialog.getSelection());	
						}
					}else{
						loader.setSelection((CBECommonBaseEvent)((SourceOutOfPageMessage)sel).getSource().get(0));	
					}
				}else if(sel instanceof LogAsyncMessage){
					loader.setSelection((CBECommonBaseEvent)((LogAsyncMessage)sel).getSourceNode().getElement());					
				}
			}			
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction, org.eclipse.ui.IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		if(targetPart instanceof SDView){
			view = (SDView)targetPart;
		}else{
			view = null;
		}


	}

}
