/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCThreadSleepingEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;
public class XMLmonWaitLoader extends TraceXMLFragmentLoader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	protected static final String TIMEOUT = "timeout";
	//~ Instance fields
	// ----------------------------------------------------------------------------
	protected long timeout;
	//~ Methods
	// ------------------------------------------------------------------------------------
	public void addAttribute(String name, String value) {
		switch (LoadersUtils.getHashCode(name)) {
			case TraceConstants.TIMEOUT_int :
				timeout = Long.parseLong(value);
				break;
			default :
				super.addAttribute(name, value);
				break;
		}
	}
	public void addYourselfInContext() {
		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		if (objIdRef == -1) {
			TRCThreadSleepingEvent sleepingEvent = TraceFactory.eINSTANCE.createTRCThreadSleepingEvent();
			sleepingEvent.setSleepingTime(timeout/1000);
			sleepingEvent.setTime(createDeltaTime());//time);
			sleepingEvent.setThread(theThread);
			theThread.getThreadEvents().add(sleepingEvent);
		} else {
			dispatchProcessMode(ProcessSteps.ALL);
			TRCThreadWaitingForObjectEvent threadWaitingForObjectEvent = TraceFactory.eINSTANCE.createTRCThreadWaitingForObjectEvent();
			threadWaitingForObjectEvent.setObjectWaitingFor(theObject);
			threadWaitingForObjectEvent.setThread(theThread);
			threadWaitingForObjectEvent.setTime(createDeltaTime());//time);
			threadWaitingForObjectEvent.setTimeout(timeout/1000);
			theThread.getThreadEvents().add(threadWaitingForObjectEvent);
		}
	}
	public void initialize(HierarchyContext context, String name) {
		loadToModel = context.isLoadToModel();
		super.initialize(context, name);
		timeout = 0;
	}
	protected void processEF(int step) {
		super.processEF(step);
		if ((theObject == null) || !(theObject instanceof TRCFullTraceObject)) {
			theObject = (TRCFullTraceObject) LookupServiceExtensions.getInstance().locate(context, TRCFullTraceObjectImpl.class, LoadersUtils.getLookUpKey(objIdRef));
		}
	}
	/**
	 *  
	 */
	protected void processES(int step) {
		super.processES(step);
		if (objIdRef > 0) {
			virtualObject = (VirtualObjectInfo) LookupServiceExtensions.getInstance().locate(context, VirtualObjectInfo.class, LoadersUtils.getLookUpKey(objIdRef));
			if (virtualObject != null) {
				theObject = getClassObject(virtualObject.myClass, TRCFullTraceObjectImpl.class);
			} else {
				return;
			}
		} else {
			theObject = getClassObject(theClass, TRCFullTraceObjectImpl.class);
		}
	}
	/**
	 *  
	 */
	protected void processHF(int step) {
		super.processHF(step);
		Class clazz = (TraceUtils.isBooleanOptionEnabled(context,Constants.MULTIPLE_HEAP_DUMPS) ? TRCFullHeapObjectImpl.class : TRCHeapObjectImpl.class);
		if ((theObject == null) || !(theObject instanceof TRCHeapObject)) {
			theObject = (TRCHeapObject) LookupServiceExtensions.getInstance().locate(context, clazz, LoadersUtils.getLookUpKey(objIdRef));
		}
	}
}