/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.trace.TRCGCRootType;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapRoot;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Heap Root</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapRootImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapRootImpl#getFrame <em>Frame</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapRootImpl#getHeapDump <em>Heap Dump</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapRootImpl#getThread <em>Thread</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapRootImpl#getObject <em>Object</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCHeapRootImpl extends EObjectImpl implements TRCHeapRoot {
	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final TRCGCRootType TYPE_EDEFAULT = TRCGCRootType.UNKNOWN_LITERAL;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected TRCGCRootType type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getFrame() <em>Frame</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFrame()
	 * @generated
	 * @ordered
	 */
	protected static final int FRAME_EDEFAULT = -1;

	/**
	 * The cached value of the '{@link #getFrame() <em>Frame</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFrame()
	 * @generated
	 * @ordered
	 */
	protected int frame = FRAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getThread() <em>Thread</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThread()
	 * @generated
	 * @ordered
	 */
	protected TRCThread thread = null;

	/**
	 * The cached value of the '{@link #getObject() <em>Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getObject()
	 * @generated
	 * @ordered
	 */
	protected TRCObject object = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCHeapRootImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCHeapRoot();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCGCRootType getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(TRCGCRootType newType) {
		TRCGCRootType oldType = type;
		type = newType == null ? TYPE_EDEFAULT : newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_HEAP_ROOT__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getFrame() {
		return frame;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFrame(int newFrame) {
		int oldFrame = frame;
		frame = newFrame;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_HEAP_ROOT__FRAME, oldFrame, frame));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCHeapDump getHeapDump() {
		if (eContainerFeatureID != TracePackage.TRC_HEAP_ROOT__HEAP_DUMP) return null;
		return (TRCHeapDump)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHeapDump(TRCHeapDump newHeapDump) {
		if (newHeapDump != eContainer || (eContainerFeatureID != TracePackage.TRC_HEAP_ROOT__HEAP_DUMP && newHeapDump != null)) {
			if (EcoreUtil.isAncestor(this, newHeapDump))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newHeapDump != null)
				msgs = ((InternalEObject)newHeapDump).eInverseAdd(this, TracePackage.TRC_HEAP_DUMP__GC_ROOTS, TRCHeapDump.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newHeapDump, TracePackage.TRC_HEAP_ROOT__HEAP_DUMP, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_HEAP_ROOT__HEAP_DUMP, newHeapDump, newHeapDump));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread getThread() {
		if (thread != null && thread.eIsProxy()) {
			TRCThread oldThread = thread;
			thread = (TRCThread)eResolveProxy((InternalEObject)thread);
			if (thread != oldThread) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_HEAP_ROOT__THREAD, oldThread, thread));
			}
		}
		return thread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread basicGetThread() {
		return thread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setThread(TRCThread newThread) {
		TRCThread oldThread = thread;
		thread = newThread;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_HEAP_ROOT__THREAD, oldThread, thread));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject getObject() {
		if (object != null && object.eIsProxy()) {
			TRCObject oldObject = object;
			object = (TRCObject)eResolveProxy((InternalEObject)object);
			if (object != oldObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_HEAP_ROOT__OBJECT, oldObject, object));
			}
		}
		return object;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject basicGetObject() {
		return object;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setObject(TRCObject newObject) {
		TRCObject oldObject = object;
		object = newObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_HEAP_ROOT__OBJECT, oldObject, object));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_HEAP_ROOT__HEAP_DUMP:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_HEAP_ROOT__HEAP_DUMP, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_HEAP_ROOT__HEAP_DUMP:
					return eBasicSetContainer(null, TracePackage.TRC_HEAP_ROOT__HEAP_DUMP, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_HEAP_ROOT__HEAP_DUMP:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_HEAP_DUMP__GC_ROOTS, TRCHeapDump.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_HEAP_ROOT__TYPE:
				return getType();
			case TracePackage.TRC_HEAP_ROOT__FRAME:
				return new Integer(getFrame());
			case TracePackage.TRC_HEAP_ROOT__HEAP_DUMP:
				return getHeapDump();
			case TracePackage.TRC_HEAP_ROOT__THREAD:
				if (resolve) return getThread();
				return basicGetThread();
			case TracePackage.TRC_HEAP_ROOT__OBJECT:
				if (resolve) return getObject();
				return basicGetObject();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_HEAP_ROOT__TYPE:
				setType((TRCGCRootType)newValue);
				return;
			case TracePackage.TRC_HEAP_ROOT__FRAME:
				setFrame(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_HEAP_ROOT__HEAP_DUMP:
				setHeapDump((TRCHeapDump)newValue);
				return;
			case TracePackage.TRC_HEAP_ROOT__THREAD:
				setThread((TRCThread)newValue);
				return;
			case TracePackage.TRC_HEAP_ROOT__OBJECT:
				setObject((TRCObject)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_HEAP_ROOT__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case TracePackage.TRC_HEAP_ROOT__FRAME:
				setFrame(FRAME_EDEFAULT);
				return;
			case TracePackage.TRC_HEAP_ROOT__HEAP_DUMP:
				setHeapDump((TRCHeapDump)null);
				return;
			case TracePackage.TRC_HEAP_ROOT__THREAD:
				setThread((TRCThread)null);
				return;
			case TracePackage.TRC_HEAP_ROOT__OBJECT:
				setObject((TRCObject)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_HEAP_ROOT__TYPE:
				return type != TYPE_EDEFAULT;
			case TracePackage.TRC_HEAP_ROOT__FRAME:
				return frame != FRAME_EDEFAULT;
			case TracePackage.TRC_HEAP_ROOT__HEAP_DUMP:
				return getHeapDump() != null;
			case TracePackage.TRC_HEAP_ROOT__THREAD:
				return thread != null;
			case TracePackage.TRC_HEAP_ROOT__OBJECT:
				return object != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (type: ");
		result.append(type);
		result.append(", frame: ");
		result.append(frame);
		result.append(')');
		return result.toString();
	}

} //TRCHeapRootImpl
