/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Feb 10, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.logc.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.logc.LogCorrelatorPlugin;
import org.eclipse.hyades.logc.extensions.ICorrelationMonitor;
import org.eclipse.hyades.logc.extensions.ILogRecordCorrelationEngine;
import org.eclipse.hyades.logc.extensions.ILogRecordFilter;
import org.eclipse.hyades.logc.internal.extensions.ProgressMonitorAdapter;
import org.eclipse.hyades.logs.correlators.RecordList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class CorrelationHelper {

	private static CorrelationHelper instance;	
	private List agentsList = new ArrayList();
	
	protected CorrelationHelper(){
	}

	class CorrelationJob extends Job{
		
		private ILogRecordCorrelationEngine recordCorrelator;
		private EList recordListToCorrelate;
		private CorrelationContainerProxy container;
		
		CorrelationJob(String name, ILogRecordCorrelationEngine recordCorrelator, CorrelationContainerProxy container, EList recordListToCorrelate){
			super(name);
			this.recordCorrelator = recordCorrelator;
			this.container = container;
			this.recordListToCorrelate = recordListToCorrelate;			
		}
		/* (non-Javadoc)
		 * @see org.eclipse.core.internal.jobs.InternalJob#run(org.eclipse.core.runtime.IProgressMonitor)
		 */
		protected IStatus run(IProgressMonitor monitor) {
			ICorrelationMonitor correlationMonitor = new ProgressMonitorAdapter(monitor);			
			recordCorrelator.correlate(container, recordListToCorrelate, correlationMonitor);			
			return new Status(IStatus.OK, LogCorrelatorPlugin.getPluginId(), IStatus.OK, "", null);
		}
}
	
	public static CorrelationHelper getInstance(){
		if(instance==null){
			instance = new CorrelationHelper();
		}		
		return instance;
	}
	
	public IExtension[] getCorrelationExtensions(){
		
		IPluginRegistry registry = Platform.getPluginRegistry();
		IExtensionPoint point =	registry.getExtensionPoint("org.eclipse.hyades.logc.logInteractionView");//$NON-NLS-1$
		IExtension[] extensions = null;
		if (point != null) {
			extensions = point.getExtensions();
		}
		return extensions;
	}
	
	public IConfigurationElement getCorrelationByName(String name) {
			IExtension[] extensions = getCorrelationExtensions();
			if (extensions!=null) {
				for (int i = 0; i < extensions.length; i++) {
					IConfigurationElement[] elements =	extensions[i].getConfigurationElements();
					for (int j = 0; j < elements.length; j++) {
						IConfigurationElement elem = elements[j];
						if ("view".equals(elements[j].getName()) //$NON-NLS-1$
						&& elements[j].getAttribute("name").equals(name))
							return elem;
					}
				}
			}
		return null;
	}
	
	public CorrelationContainerProxy createCorrelationContainer(IConfigurationElement correlation, Object inputObject, String name){
		agentsList.clear();
		if(correlation==null){
			return null;
		}
		loadLogAgents(inputObject);
		BasicEList recordListToCorrelate = new BasicEList();
		String correlationType = null;
		CorrelationContainerProxy correlationContainerProxy = null;
		ILogRecordCorrelationEngine recordCorrelator = null;		
		IConfigurationElement[] filters_correlators = addNodes(correlation, recordListToCorrelate);
		for (int k = 0; k < filters_correlators.length; k++)
		{
			if (filters_correlators[k].getName().equals("LogRecordCorrelationEngine"))
			{
				try 
				{
					recordCorrelator =(ILogRecordCorrelationEngine) filters_correlators[k].createExecutableExtension("class");							
					correlationType =correlation.getAttribute("name");
				}
				catch (Exception e)
				{
					
				}
			}
		}
		if (recordCorrelator != null && agentsList.size()>0)
		{
			correlationContainerProxy = LoadersUtils.getCorrelationContainerProxy((TRCAgentProxy)agentsList.get(0),correlationType,name);
			correlationContainerProxy.setName(name);
			CorrelationEngine correlationEngine = HierarchyFactory.eINSTANCE.createCorrelationEngine();
			correlationEngine.setId(correlationType);
			correlationEngine.setType(correlation.getAttribute("log_types"));
			correlationEngine.setName(correlation.getAttribute("name"));
			correlationContainerProxy.setCorrelationEngine(correlationEngine);
			for (int i = 1; i < agentsList.size(); i++) {
				if (agentsList.get(i)!=null)
				correlationContainerProxy.getCorrelatedAgents().add(agentsList.get(i));	
			}
			
			Job correlationJob = new CorrelationJob(LogCorrelatorPlugin.getResourceString("STR_JOB_LBL"), recordCorrelator, correlationContainerProxy, recordListToCorrelate);
			correlationJob.schedule();			
		}		
		return correlationContainerProxy;
	
	}
	
	
	
	private IConfigurationElement[] addNodes(IConfigurationElement correlation, BasicEList recordListToCorrelate) {
		IConfigurationElement[] filters_correlators =correlation.getChildren();
		ILogRecordFilter logFilter = null;

		boolean notAdded = true;
		for (int i = 0; i < agentsList.size(); i++) 
		{
			if (agentsList.get(i) != null) 
			{
				for (int k = 0;k < filters_correlators.length;k++) 
				{
					//TODO Check the name comparison, it contains a bug, the agent name doesn't match the filter anymore
					if (filters_correlators[k].getName().equals("LogRecordFilter")&& ((TRCAgentProxy)agentsList.get(i)).getName().equals(filters_correlators[k].getAttribute("log_type")))
					{
						try 
						{
							logFilter =(ILogRecordFilter) filters_correlators[k].createExecutableExtension("class");
							recordListToCorrelate.add(loadLog((TRCAgentProxy)agentsList.get(i),logFilter));
							notAdded = false;
						} 
						catch (Exception e)
						{	
							recordListToCorrelate.add(loadLog((TRCAgentProxy)agentsList.get(i), null));
							notAdded = false;
						}
					} 
					else if (((TRCAgentProxy)agentsList.get(i)).getName().equals(filters_correlators[k].getAttribute("log_type"))) 
					{
						recordListToCorrelate.add(loadLog((TRCAgentProxy)agentsList.get(i), null));
						notAdded = false;
					}
				}
				if (notAdded)
				{
					recordListToCorrelate.add(loadLog((TRCAgentProxy)agentsList.get(i), null));
				}
			}
			notAdded = true;
		}
		return filters_correlators;
	}

	private RecordList loadLog(TRCAgentProxy agent, ILogRecordFilter logFilter){
		 
		 RecordList recList=null;
		 if(logFilter!=null)
			recList = new RecordList(cbeEventFilter(logFilter.filter(agent.getAgent().getDefaultEvents())),agent.getName());
		 else
			recList = new RecordList(cbeEventFilter(agent.getAgent().getDefaultEvents()),agent.getName());
		 
		 return recList;
	}
	
	private EList cbeEventFilter(EList list)
	{
		
		EList filteredList = new BasicEList();
		Iterator it = list.iterator();
		while (it.hasNext()) {
			Object event = it.next();
			if (event instanceof CBECommonBaseEvent) {
				filteredList.add(event);
			}
		}
		return filteredList;		
	}

	private void loadLogAgents(Object object){
				
		if(object instanceof List){
			Object element = null;
			for (Iterator iter = ((List)object).iterator(); iter.hasNext();) {
				element = iter.next();
				if(element instanceof TRCAgentProxy && ((TRCAgentProxy)(element)).getType().equals(Constants.LOGGING_AGENT_TYPE)){
					agentsList.add(element);
				}				
			}
		}else
		if(object instanceof CorrelationContainerProxy)
		{

			for (Iterator iter = ((CorrelationContainerProxy)object).getCorrelatedAgents().iterator(); iter.hasNext();) {
				TRCAgentProxy trcAgentProxy = (TRCAgentProxy) iter.next();
				if (trcAgentProxy != null && !trcAgentProxy.eIsProxy())
				{
					agentsList.add(trcAgentProxy);

				}
			}
			IConfigurationElement correlation = getCorrelation(((CorrelationContainerProxy)object).getCorrelationEngine());
			if(correlation!=null)
				addNodes(correlation, new BasicEList());
			else
			{
				if(isInternalCorrelation((CorrelationContainerProxy)object))
				{
					addAllNodes();
				}
			}
		}else
		 if(object instanceof TRCMonitor)
			loadAllAgents((TRCMonitor)object);
		 else if(object instanceof TRCNode)
			loadAllAgents((TRCNode)object);
		 else if(object instanceof TRCProcessProxy)
			loadAllAgents((TRCProcessProxy)object);
		 else if(object instanceof TRCAgentProxy && ((TRCAgentProxy)(object)).getType().equals(Constants.LOGGING_AGENT_TYPE))
			agentsList.add((TRCAgentProxy)object);	
	
	}
	
	private boolean isInternalCorrelation(CorrelationContainerProxy correlationContainerProxy) {
		for (Iterator iter = correlationContainerProxy.getCorrelatedAgents().iterator(); iter.hasNext();) {
			TRCAgentProxy agentProxy = (TRCAgentProxy) iter.next();
			if(agentProxy.getInternalCorrelations().contains(correlationContainerProxy))
				return true;
		}
		return false;
	}	
	
	private void addAllNodes() {
		for (int i = 0; i < agentsList.size(); i++) 
		{
			if (agentsList.get(i) != null) 
			{
				loadLog((TRCAgentProxy)agentsList.get(i),null);
			}
		}
	}	
	
	public IConfigurationElement getCorrelation(CorrelationEngine engine) {
		String name = engine.getName();
		IPluginRegistry registry = Platform.getPluginRegistry();
		IExtensionPoint point = registry.getExtensionPoint("org.eclipse.hyades.logc.logInteractionView"); //$NON-NLS-1$
		if (point != null) {
  		
			IExtension[] extensions = point.getExtensions();			
			for (int i = 0; i < extensions.length; i++) {
				IConfigurationElement[] elements =	extensions[i].getConfigurationElements();
				for (int j = 0; j < elements.length; j++) {
  				
					IConfigurationElement elem = elements[j];
					if ("view".equals(elements[j].getName()) //$NON-NLS-1$
							&& elements[j].getAttribute("name").equals(name))
						return elem;
				}
			}			
		}
  	
		return null;
	  }
	
	private void loadAllAgents(TRCMonitor monitor)
		{
			if (monitor != null)
			{
				for (Iterator nodes = monitor.getNodes().iterator(); nodes.hasNext();)
				{
					TRCNode node = (TRCNode) nodes.next();
					if (node != null)
					{
						loadAllAgents(node);
					} 
				}
			}
		}
	private void loadAllAgents(TRCNode node)
	{
		for (Iterator processProxies = node.getProcessProxies().iterator(); processProxies.hasNext();)
		{
			TRCProcessProxy processProxy = (TRCProcessProxy) processProxies.next();
			if (processProxy != null)
			{
				loadAllAgents(processProxy);
			}
		} // processProxies loop
	}

	private void loadAllAgents(TRCProcessProxy processProxy)
	{
		for (Iterator agents = processProxy.getAgentProxies().iterator(); agents.hasNext();)
		{
			TRCAgentProxy trcAgent = (TRCAgentProxy) agents.next();
			if (trcAgent != null && !trcAgent.eIsProxy() && ((TRCAgentProxy)(trcAgent)).getType().equals(Constants.LOGGING_AGENT_TYPE))
			{
				agentsList.add(trcAgent);
			}
		} // agent loop
	}

}
