package org.eclipse.hyades.execution.local;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.util.Enumeration;

import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IRemoteHyadesComponent;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;

public class JavaProcessExecutorStub extends ExecutorStub {
	
	
	
	public void launch() throws ExecutionComponentStateException {
		/* Launch the process */
		super.launch();
		
		int trialCount=60;
		
		/* Get the process ID of the new process */
		String pid=getPid();
		
		/* Create a process model and agent for the other side */
		try {
			boolean found=false;
			Node node=((SessionStub)getSessionContext()).getAgent().getProcess().getNode();
			
			while(!found && trialCount>0) 
			{
				Enumeration processes=node.listProcesses();
				
				while(processes.hasMoreElements()) {
					Process proc=(Process)processes.nextElement();
					if(proc.getProcessId().equals(pid)) {
						
						found=true;
						synchronized(proc) {
							Enumeration agents=proc.getAgentsByType("tester");
							while(agents.hasMoreElements()) 
							{
								Agent agent=(Agent)agents.nextElement();
								try 
								{
									
									agent.addAgentListener(new AgentListener() 
									{

										public void error(Agent agent, String errorId, String errorMessage) 
										{
										}

										public void handleCommand(Agent agent, CommandElement command) {
											if(command instanceof CustomCommand) {
												String errorMessage=((CustomCommand)command).getData();
												System.out.println("recieving message: "+errorMessage);
											}
										}

										public void agentActive(Agent agent) {
										}

										public void agentInactive(Agent agent) {	
										}									
									});
									
									agent.attach();
									
									/* Find our RemoteHyadesComponent and set the agent */
									IExecutionComponent[] children=getChildren();
									for (int i=0; i<children.length;i++) {
										if(children[i] instanceof IRemoteHyadesComponent) {
											((JavaTaskRemoteHyadesComponentStub)children[i]).setAgent(agent);
										}
									}

									
									try
									{
										IExecutableObject executableObject = getExecutableObject();
										if(executableObject instanceof JavaProcessExecutableObjectStub)
										{
											String script = ((JavaProcessExecutableObjectStub)executableObject).getAgentData();
											if(script != null)
											{
												BinaryCustomCommand agentData = new BinaryCustomCommand();
												agentData.setData(script.getBytes("UTF-8"));
												agent.invokeCustomCommand(agentData);
											}
										}
									}
									catch(Exception e1)
									{
										e1.printStackTrace();
									}
									
//									CustomCommand resumeCommand=new CustomCommand();
//									resumeCommand.setData(IControlMessage.START);
//									agent.invokeCustomCommand(resumeCommand);
								}
								catch(InactiveAgentException e) {
									
								}
								
							}
						}
					}
					try {
						Thread.sleep(1000);	
					}
					catch(InterruptedException e) {
					}
					trialCount--;
				}
			}
			
		}
		catch(InactiveProcessException e) {
			/* We can ignore this as our process is running */
		}
		catch(NotConnectedException e) {
			/* Wecan ignore this as we are connected */
		}
		
		
		
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IExecutor#supportsControlEvent(java.lang.String)
	 */
	public boolean supportsControlEvent(String controlEvent) {
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IExecutor#performControlEvent(java.lang.String)
	 */
	public String performControlEvent(String controlEvent, String[] params) {
		return "";
	}

}
