/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

import java.util.Vector;

public class PropertyListCommand extends CommandElement implements Constants {
	protected int size = 0;
	protected Vector names = new Vector();
	protected Vector types = new Vector();
	protected Vector values = new Vector();

	public PropertyListCommand() {
		super();
		_tag = RA_PROPERTY_LIST;
	}

	public int getPropertyListLength() {
		return size;
	}

	public SetNVPairCommand[] getPropertyListValues() {
		SetNVPairCommand[] results = new SetNVPairCommand[size];
		for(int i = 0; i < size; i++) {
			results[i] = new SetNVPairCommand();
			results[i].setName(((RAString)names.elementAt(i)).getData());
			results[i].setType(((RAString)types.elementAt(i)).getData());
			results[i].setValue(((RAString)values.elementAt(i)).getData());
		}
		return results;
	}

	public int readFromBuffer(byte[] buffer, int offset) {
		int current = offset;

		// Get the context value
		_context = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		// Read the number of entries
		size = (int)Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		// Read the name, type, value entries
		for(int i = 0; i < size; i++) {
			RAString name = new RAString("");
			RAString type = new RAString("");
			RAString value = new RAString("");
			current = Message.readRAStringFromBuffer(buffer, current, name);
			current = Message.readRAStringFromBuffer(buffer, current, type);
			current = Message.readRAStringFromBuffer(buffer, current, value);
			names.addElement(name);
			types.addElement(type);
			values.addElement(value);
		}

		return current;
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = Message.writeRALongToBuffer(buffer, current, _tag);
		current = Message.writeRALongToBuffer(buffer, current, _context);

		/* Names */
		current = Message.writeRALongToBuffer(buffer, current, size);
		for(int i = 0; i < size; i++) {
			current = Message.writeRAStringToBuffer(buffer, current, ((RAString)names.elementAt(i)));
			current = Message.writeRAStringToBuffer(buffer, current, ((RAString)types.elementAt(i)));
			current = Message.writeRAStringToBuffer(buffer, current, ((RAString)values.elementAt(i)));
		}

		return current;
	}

	public int getSize() {
		int size = 0;

		size += sizeofLong; // tag
		size += sizeofLong; // context

		size += sizeofLong; // entry size
		for(int i = 0; i < size; i++) {
			size += ((RAString)names.elementAt(i)).getSize();
			size += ((RAString)types.elementAt(i)).getSize();
			size += ((RAString)values.elementAt(i)).getSize();
		}

		return size;
	}
}
