/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.harness;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IOrderedProperty;
import org.eclipse.hyades.execution.core.impl.OrderedPropertyImpl;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

/**
 * @author jtoomey
 * @author marcelop
 * @author bjiang
 */
public class JavaExecutionEnvironmentAdapter
implements IExecutionEnvironmentAdapter
{
	/**
	 * @see org.eclipse.hyades.execution.harness.IExecutionEnvironmentAdapter#setupExecutionEnvironment(org.eclipse.hyades.execution.core.IExecutionEnvironment, org.eclipse.hyades.models.common.testprofile.TPFTestSuite, java.lang.String)
	 */
	public void setupExecutionEnvironment(IExecutionEnvironment executionEnvironment, CFGClass rootResource, IImplementor theImplementor, TPFDeployment deployment)
		throws ClassCastException {	   

	    BVRProperty[] properties = null;
	    List environmentVariableProperties = ((IDeployableComponent)rootResource).getEnvironmentVariables().getProperties();
	    
	    CFGLocation location = null;
	    if(rootResource instanceof TPFTestSuite)
	    {
	        if(!deployment.getArtifactLocations().isEmpty())
	        {
	            for(Iterator i = deployment.getArtifactLocations().iterator(); i.hasNext(); )
	            {
	                CFGArtifactLocationPair pair = (CFGArtifactLocationPair)i.next();
	                if(ConfigurationUtil.containsById(pair.getArtifact().getDeployableInstances(), rootResource))
	                {
	                    location = pair.getLocation();
	                    break;
	                }
	            }
	        }
	    }
	    
	    if(location != null)
	    {
	        CFGPropertyGroup propGroup = ConfigurationUtil.searchPropertyGroupById(location.getPropertyGroups(), ConfigurationUtil.ATTRS_PROP_GROUP_ID_LOCATION);
	        if(propGroup != null)
	        {
	            properties = ConfigurationUtil.searchPropertiesByName(propGroup.getProperties(), ConfigurationUtil.CLASSPATH, false);
	            if(properties != null && properties.length > 0 && environmentVariableProperties != null)
	            {
	    			environmentVariableProperties.clear();
	    			environmentVariableProperties.addAll(Arrays.asList(properties));
	            }
	        }
	    }
	    else
	    {
			if(environmentVariableProperties == null)
				return;
			properties = new BVRProperty[environmentVariableProperties.size()];
			int index = 0;
			for(Iterator i = environmentVariableProperties.iterator(); i.hasNext();)
			{		    
				properties[index] = (BVRProperty)i.next();
				index++;
			}
	    }
	    
	    if(properties == null || properties.length == 0)
	        return;
			
	    for(int i = 0; i < properties.length; i++)
	    {
			IOrderedProperty orderedProperty = executionEnvironment.getEnvByName(properties[i].getName());
			if(orderedProperty == null)
			{
				orderedProperty = new OrderedPropertyImpl();
				orderedProperty.setName(properties[i].getName());
			}
			orderedProperty.appendValue(properties[i].getValue());			
			executionEnvironment.setEnv(orderedProperty);
		}
	}
}
