/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Mar 4, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.internal.execution.recorder.ui.wizards;

import java.io.File;
import java.io.FileInputStream;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

/**
 * @author mdunn
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class RecorderRegistryInfo {
	
	private String proxyType = "";
	private String proxyAddr = "";
	private String proxyPort = "";
	private boolean isProxyEnabled = false;
	private boolean badProxySettings = false;
	private int proxyError = 0;
	public final int PROXY_SETTINGS_OK = 0;
	public final int SOCKS_SET = -1;
	public final int HTTP_PROXY_ONLY_SET = -2;
	public final int SECURE_PROXY_ONLY_SET = -3;
	public final int HTTP_SECURE_MISMATCH = -4;
	public final int HTTP_SECURE_LOCALHOST = -5;
	
	public RecorderRegistryInfo() {
		StringBuffer inputFileContents = getRegistryInfo();
		boolean isEnabled = checkProxyEnabled(inputFileContents);
		setProxyEnabled(isEnabled);
		if (! isEnabled ) {
			setProxyType("socks");
		}
		else {	
			// must do it new way for hyades 1.3 mdd
			// make sure it is http proxy, grab the address and port
			// then set ProxyServer http=localhost:1080
			String proxyInfo = getProxyInfo(inputFileContents);
			if (proxyInfo.length()!= 0) {
				String[] proxySplit = proxyInfo.split(":");
				String myProxyAddr = proxySplit[0];
				String myProxyPort = proxySplit[1];
				setProxyAddr(myProxyAddr);	
				setProxyPort(myProxyPort);
				setProxyType("http");
			}
			else {
				setProxyType("socks");
			}
		}
	}

	private StringBuffer getRegistryInfo()
	{
		String originalSettingsFileName = "newSettingsFile.tmp";
		String getOriginalInfoCommandLine = "regedit /e "+originalSettingsFileName+" \"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\"";//$NON-NLS-1$//$NON-NLS-2$
		InputStreamReader inputReader=null;
		File file = null;
		StringBuffer inputFileContents = new StringBuffer();
		try
		{
			Process registryChange = Runtime.getRuntime().exec(getOriginalInfoCommandLine,null);
			registryChange.waitFor();
			file = new File(originalSettingsFileName);
			inputReader= new InputStreamReader(new FileInputStream(file),"UTF-16");//$NON-NLS-1$
			inputFileContents = new StringBuffer();
			char[] inputBuf = new char[1000];
			int bytesRead = inputReader.read(inputBuf);
								
			while(bytesRead!=-1)
			{				
				String buf = new String(inputBuf);				
				inputFileContents.append(inputBuf,0,bytesRead);
				bytesRead = inputReader.read(inputBuf);
			}			
		}
		catch (IOException e)
		{
			e.printStackTrace();
		} 
		catch (InterruptedException e)
		{
			e.printStackTrace();
		}
		finally
		{
			if(inputReader!=null)
				try
				{
					inputReader.close();
				}
				catch (IOException e1)
				{
					e1.printStackTrace();
				}
		}
		// Clean up
		if (file.exists())
			file.delete();
		return inputFileContents;
	}
	private boolean checkProxyEnabled(StringBuffer inputBuffer) 
	{
			boolean comparesOK = false;
			StringTokenizer fileTokenizer = new StringTokenizer(inputBuffer.toString(),"\r\n");//$NON-NLS-1$
			while(fileTokenizer.hasMoreTokens())
			{
				String line=fileTokenizer.nextToken();
				String newLine = line;
				// example ProxyServer is key, "http=markdunn:1000;socks=localhost:450"
				if(line.startsWith("\"ProxyEnable"))//$NON-NLS-1$
				{
					StringTokenizer lineTokenizer = new StringTokenizer(line,":");//$NON-NLS-1$
					newLine=lineTokenizer.nextToken();  // get ProxyEnable
					newLine=lineTokenizer.nextToken();
					if (newLine.equalsIgnoreCase("00000001"))
						comparesOK = true;
				
					break;				
				}
			}
		return comparesOK;
	}
	
	private String getProxyInfo(StringBuffer inputBuffer) 
	{
		boolean comparesOK = false;
		String proxyString = "";
		String httpString = "http=";
		String secureString = "https=";
		String socksString = "socks=";
		String equalsString = "=";
		String HTTPString = "";
		String SECUREString = "";
		int findSOCKS = -1;
		int findHTTP = -1;
		int findSECURE = -1;
		StringTokenizer fileTokenizer = new StringTokenizer(inputBuffer.toString(),"\r\n");//$NON-NLS-1$
		while(fileTokenizer.hasMoreTokens())
		{
			String line=fileTokenizer.nextToken();
			String newLine = line;
			// example ProxyServer is key, "http=markdunn:1000;https=mdunnlinux:3128;socks=localhost:450"
			// or "mdunnlinux:3128 - which means use this proxy for all protocols
			
			if(line.startsWith("\"ProxyServer"))//$NON-NLS-1$
			{
				String tmp = "\"ProxyServer\"=";
				String modifiedLine = line.substring(tmp.length());
				String [] entireString = modifiedLine.split(";");
				int numVars = entireString.length;
				for (int i =0; i < numVars; i++){
					String tmpEntireString = entireString[i].replaceAll("\"","");
					int findEqualsString = tmpEntireString.indexOf(equalsString);
					if (findEqualsString == -1) {
						proxyString = tmpEntireString;
					} 
					else {
						if (findSOCKS == -1){
							findSOCKS = tmpEntireString.indexOf(socksString);
							if (findSOCKS >= 0)
								break;
						} 
						if (findHTTP == -1) {
							findHTTP = tmpEntireString.indexOf(httpString);
							if (findHTTP >= 0)
								HTTPString = tmpEntireString;
						}
						if (findSECURE == -1) {
							findSECURE = tmpEntireString.indexOf(secureString);
							if (findSECURE >= 0)
								SECUREString = tmpEntireString;
						}
					}
				}
				if (findSOCKS >= 0) {
					setBadProxySettings(true);
					setProxyError(SOCKS_SET);
				}
				else {
					if ((findHTTP >= 0) && (findSECURE == -1)) {
						setBadProxySettings(true);
						setProxyError(HTTP_PROXY_ONLY_SET);
					}
					else if ((findHTTP == -1) && (findSECURE >= 0 )) {
						setBadProxySettings(true);
						setProxyError(SECURE_PROXY_ONLY_SET);
					}
					else if ((findHTTP >= 0) && (findSECURE >= 0)) {
						// if two string equal - it is OK
						// if different - then ERROR
						// HTTPString=http=mdunnlinux:3128 
						// SECUREString=https=mdunnlinux3128
						// must first strip off up to '=' and then compare
						int httpEQUALS = HTTPString.indexOf("=");
						int secureEQUALS = SECUREString.indexOf("=");
						String tmpHTTP = HTTPString.substring(httpEQUALS+1);
						String tmpSECURE = SECUREString.substring(secureEQUALS+1);
						//if (HTTPString.equalsIgnoreCase(SECUREString)){
						if (tmpHTTP.equalsIgnoreCase(tmpSECURE)){
							if (tmpHTTP.startsWith("localhost")) {
								setBadProxySettings(true);
								setProxyError(HTTP_SECURE_LOCALHOST);
							}
							else {
								setBadProxySettings(false);
								setProxyError(PROXY_SETTINGS_OK);
								String tmpVal = "";
								tmpVal = HTTPString.substring(findHTTP+httpString.length());
								proxyString = tmpVal;
							}
						}
						else {
							setBadProxySettings(true);
							setProxyError(HTTP_SECURE_MISMATCH);
						}
					}
				}
			}
		}
		return proxyString;
	}

	/**
	 * @param string
	 */
	public void setProxyType(String string) {
		proxyType = string;
	}
	/**
	 * @return
	 */
	public String getProxyType() {
		return proxyType;
	}

	/**
	 * @param string
	 */
	public void setProxyPort(String string) {
		proxyPort = string;
	}
	/**
	 * @return
	 */
	public String getProxyPort() {
		return proxyPort;
	}

	/**
	 * @return
	 */
	public boolean isProxyEnabled() {
		return isProxyEnabled;
	}

	/**
	 * @param b
	 */
	public void setProxyEnabled(boolean b) {
		isProxyEnabled = b;
	}

	/**
	 * @return
	 */
	public String getProxyAddr() {
		return proxyAddr;
	}

	/**
	 * @param string
	 */
	public void setProxyAddr(String string) {
		proxyAddr = string;
	}

	/**
	 * @return Returns the badProxySettings.
	 */
	public boolean isBadProxySettings() {
		return badProxySettings;
	}
	/**
	 * @param badProxySettings The badProxySettings to set.
	 */
	public void setBadProxySettings(boolean badProxySettings) {
		this.badProxySettings = badProxySettings;
	}
	/**
	 * @return Returns the proxyError.
	 */
	public int getProxyError() {
		return proxyError;
	}
	/**
	 * @param proxyError The proxyError to set.
	 */
	public void setProxyError(int proxyError) {
		this.proxyError = proxyError;
	}
}
