/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.*;
import org.eclipse.swt.graphics.*;

public interface Graph {

	public BasicGraphSource getGraphSource();

	public double getXMin();
	public double getXMax();
	public double getYMin();
	public double getYMax();
	public void paintGraph(GC gc, int x, int y, int w, int h);
	public void setXSlider(TimeZoomSlider slider);
	public void setYSlider(ZoomSlider slider);
	public TimeZoomSlider getXSlider();
	public ZoomSlider getYSlider();
	public void setForeground(Color col);
	public Color getForeground();
	public void setLineWidth(int w);
	public int getLineWidth();
	public void setLineStyle(int swt_line_style);
	public int getLineStyle();
	public void setStaticScaling(double mult); 
	public double getStaticScaling(); 
	
	public void setUseIndicator(boolean b);
	public void setIndicatorSource(IndicatorSource isource);
}