/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import java.util.Vector;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ZoomIndicatorsCollection
{
    static final int IDEAL_WIDTH = 7;
    static final int INDENT = 6;
    
    ZoomSlider slider;
    
    Vector indicators = new Vector();
    
    int width = IDEAL_WIDTH;
    int startPoint;
    
    public ZoomIndicatorsCollection(ZoomSlider slider)
    {
        this.slider = slider;
    }
    
    public void add(ZoomIndicator indicator)
	{
	    if (indicator != null)
	    {
	        if (!indicators.contains(indicator))
	        {
	            indicators.addElement(indicator);
	            
	            calculatePositions();
	        }
	    }    
	}
	    
	public void remove(ZoomIndicator indicator)
	{
	    if (indicator != null)
	    {
	        if (indicators.contains(indicator))
	        {
	            indicators.removeElement(indicator);
	    
	            calculatePositions();
    	    }
	    }    
	}
	
	public void calculatePositions()
	{
        if (indicators.size() > 0)
        {
            int base = slider.getBounds().width;
            
            if (slider.getOrientation() == ZoomSlider.HORIZONTAL)
            {
                base = slider.getBounds().height;
            }

	        width = (base - (INDENT * 2))/indicators.size();
	        
	        if (width > IDEAL_WIDTH) width = IDEAL_WIDTH;
    	        
	        startPoint = base/2 - ((width/2) * indicators.size());
        }	    
	}    
	    
	public void paint(GC g, Image backBuffer)
	{
	    for (int i=0; i<indicators.size(); i++)
	    {
	        ((ZoomIndicator)(indicators.elementAt(i))).paint(g, backBuffer, startPoint + (i * width), width);
	    }
	}
	
	public Vector getZoomIndicators()
	{
	    return indicators;
	}
	
	public void setXORColors()
	{
	    for (int i=0; i<indicators.size(); i++)
	    {
	        ((ZoomIndicator)(indicators.elementAt(i))).setXORColor();
	    }
	}
	
	public void dispose()
	{
	    for (int i=0; i<indicators.size(); i++)
	    {
	        ((ZoomIndicator)(indicators.elementAt(i))).dispose();
	    }
	}		
}    
    
