/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import java.math.BigDecimal;

public class ZoomSliderUtilities
{
    // CALCULATE ORDER OF MAGNITUDE
    public static int calculateOOM(double n)
    {
        int oom = 0;
        double old;
        
        if (n == 0.0) 
        {
            return 1;
        }

        while (n >= 10)
        {
            oom++;
            old = n;
            n = n / 10;
            if (old == n) break;
        }

        while (n < 1)
        {
            oom--;
            old = n;
            n = n * 10;
            if (old == n) break;
        }

        return oom;
    }

    // ROUND
    /** Round to the nearest multiple of rounder */
    public static double round(double roundee, double rounder)
    {
        BigDecimal biggy = new BigDecimal(roundee/rounder);
        
        biggy = biggy.setScale(0, BigDecimal.ROUND_HALF_UP);
        
        biggy = biggy.multiply(new BigDecimal(rounder));
        
        int scale = 0;
        
        if (rounder < 1) scale = Math.abs(calculateOOM(rounder));
        
        biggy = biggy.setScale(scale, BigDecimal.ROUND_HALF_UP);
        
        return biggy.doubleValue();
    }
    

    public static String double2String(double n)
    {
        String string = String.valueOf(n);
        
        String whole = "";
        String fraction = "";
        
        int eIndex = string.indexOf('E');
        
        if (eIndex == -1)
        {
            int pointIndex = string.indexOf('.');
        
            whole = string.substring(0, pointIndex);
        
            fraction = string.substring(pointIndex + 1);
        }
        else
        {
            String base = string.substring(0, eIndex);
        
            int exponent = Integer.valueOf(string.substring(eIndex + 1)).intValue();
            
            int pointIndex = base.indexOf('.');
            
            whole = base.substring(0, pointIndex);
            
            fraction = base.substring(pointIndex + 1);
            
            if (fraction.endsWith("0"))
            {
                fraction = fraction.substring(0, fraction.length() - 1);
            }
            
            if (exponent < 0)
            {
                exponent = Math.abs(exponent);
                
                if (exponent <= whole.length())
                {
                    whole = whole.substring(0, exponent);
                    fraction = whole.substring(exponent) + fraction;
                }
                else
                {
                    int zeroCount = exponent - whole.length();
                
                    fraction = whole + fraction;
                    whole = "0";
                    
                    for (int i=0; i<zeroCount; i++)
                    {
                        fraction = "0" + fraction;
                    }
                }    
            }
            else
            {
                if (exponent <= fraction.length())
                {
                    whole = whole + fraction.substring(0, exponent);
                    fraction = fraction.substring(exponent);
                }
                else
                {
                    int zeroCount = exponent - fraction.length();
                
                    whole = whole + fraction;
                    fraction = "0";
                    
                    for (int i=0; i<zeroCount; i++)
                    {
                        whole = whole + "0";
                    }
                }    
            }
        }    

        if (fraction.equals("") || fraction.equals("0"))
        {
            return whole;
        }
        
        return whole + "." + fraction;        
    }
}	
