/**********************************************************************
 * Copyright (c) 2003-2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCSourceInfo;

/**
 * Here are some utilities related to Coverage feature
 */
public class CoverageUtil {

	/**
	 * @param e
	 * @return source location signature if any
	 */
	private static String getSourceSig(TRCSourceInfo e) {
		return (e != null ? e.getLocation()+":" : "");
	}
	
	/**
	 * @param e
	 * @return
	 */
	public static String getFullSig(TRCMethod e) {
		return  getSourceSig(e.getSourceInfo())+
				e.getLineNo()+":"+
				getSig(e.getDefiningClass())+"."+
				e.getName()+
				e.getSignature();
	}

	/**
	 * @param e
	 * @return
	 */
	public static String getFullSig(TRCClass e) {
		return  getSourceSig(e.getSourceInfo())+
				e.getLineNo()+":"+
				getSig(e);
	}

	/**
	 * @param e
	 * @return
	 */
	public static String getFullSig(TRCPackage e) {
		return e.getName();
	}
	
	/**
	 * @param e
	 * @return qualified name of the class
	 */
	private static String getSig(TRCClass e) {
		return (e.getPackage().getName() == null ? "" : (e.getPackage().getName()+"."))+
				e.getName();
	}
	
	/**
	 * This is for post-filtering needed because of the boundary classes collected even if excluded
	 * by the filter set.<br>
	 * The empty packages are filtered out and
	 * those listed in the active filters for this agent configuration
	 * @param pac
	 * @return
	 */
	public static boolean isFiltered(TRCPackage pac) {
		if (pac.getClasses() == null ||
			pac.getClasses().size() == 0) {
			//if empty package
			return true;
		}

		Object[] conflist = pac.getProcess().getAgent().getAgentProxy().getConfigurations().toArray();
		return filtersMatch(conflist, pac.getName());
	}
	
	/**
	 * The empty classes are filtered out too
	 * @param c
	 * @return
	 */
	public static boolean isFiltered(TRCClass cl) {
		if (cl.getMethods() == null ||
			cl.getMethods().size() == 0) {
			//if empty class
			return true;
		}
		return false;
	}

	/**
	 * @param conflist
	 * @param name
	 * @return
	 */
	private static boolean filtersMatch(Object[] conflist, String name) {
		for(int idx = 0; idx < conflist.length; idx++){
			TRCConfiguration c = (TRCConfiguration) conflist[idx];
			if(!c.isActive())continue;
			
			Object[] filtlist = c.getFilters().toArray();
			for (int k = 0; k < filtlist.length; ++k) {
				TRCFilter f = (TRCFilter)filtlist[k];
				String pattern = f.getPattern();
				if (pattern.indexOf("*") != -1)//$NON-NLS-1$
					pattern = pattern.substring(0, pattern.indexOf("*"));//$NON-NLS-1$
				if (name.startsWith(pattern)) {
					if(f.getMode().equals("INCLUDE"))//$NON-NLS-1$
						return false;
					return true;
				}
			}
			return false;
		}
		return false;
	}

}
