/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.models.common.datapool.impl;

import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;

/**
 * @author ahoppe
 * @author psun
 * TODO: Is this class supposed to extend AbstractEnumerator? If so, it is not implemented
 */
public class DatapoolSuggestedTypeImpl implements IDatapoolSuggestedType
{
 	int suggestedType;
 	String[] enumerationLiterals;           	 
 	String className;
 	
 	
	/**
	 * Define the type associated with a variable in the associated
	 * datapool.
	 * 
	 * @param	type	One of the predefined type formats.
	 * 
	 * @see #TYPE_STRING
	 * @see #TYPE_NUMBER
	 * @see #TYPE_BOOLEAN
	 * @see #TYPE_ENUMERATION
	 * @see #TYPE_COMPLEX
	 * @see	#getSuggestedType()
	 */
	public void setSuggestedType(int type)
	{
		if (type < 0 || type >  TYPE_COMPLEX)
		    throw new org.eclipse.hyades.execution.runtime.datapool.DatapoolException
		       ("Variable Suggested Type Out of Range"); 
		suggestedType = type;
	}

	/**
	 * Defines the set of enumerations literals associated with a
	 * {@link #TYPE_ENUMERATION enumeration} type.  If the
	 * {@link #getSuggestedType() type} is not set to a
	 * {@link #TYPE_ENUMERATION enumeration} type then an 
	 * appropriate <code>DatapoolException</code> is thrown.
	 * 
	 * @param	enumLiterals	The set of enumerations literals associated 
	 *							with a {@link #TYPE_ENUMERATION enumeration}
	 *							type.
	 * 
	 * @see #TYPE_ENUMERATION
	 * @see #getEnumerationLiterals()
	 */
	public void setEnumerationLiterals(String[] enumLiterals)
	{
		if (this.suggestedType != TYPE_ENUMERATION)
			throw new org.eclipse.hyades.execution.runtime.datapool.DatapoolException
			   ("Setting Enumeration LIterals for Non-enumeration Suggested Type");
	    this.enumerationLiterals = enumLiterals;
	} 
		
		

	/**
	 * Defines the value class name associated with a
	 * variable.
	 * 
	 * @param	complexClassName	The complex class name associated 
	 * 								with a variable
	 * 
	 * @see #getSuggestedClassName()
	 */
	public void setSuggestedClassName(String complexClassName)
	{
		this.className = complexClassName;
	}

 	
 	
 	
	/**
	 * One of the predefined type formats:
	 * <ul>
	 * <li>{@link #TYPE_STRING}
	 * <li>{@link #TYPE_NUMBER}
	 * <li>{@link #TYPE_BOOLEAN}
	 * <li>{@link #TYPE_ENUMERATION}
	 * <li>{@link #TYPE_COMPLEX}
	 * </ul>
	 * 
	 * @return	One of the predefined type values.
	 * 
	 * @see #TYPE_STRING
	 * @see #TYPE_NUMBER
	 * @see #TYPE_BOOLEAN
	 * @see #TYPE_ENUMERATION
	 * @see #TYPE_COMPLEX
	 */
	public int getSuggestedType()
	{
		return this.suggestedType;
	}
	
	

	/**
	 * The set of enumerations literals associated with a
	 * {@link #TYPE_ENUMERATION enumeration} type.  If the
	 * {@link #getSuggestedType() type} is not set to 
	 * {@link #TYPE_ENUMERATION enumeration} type then an 
	 * appropriate <code>DatapoolException</code> is thrown.
	 * 
	 * @return	The set of enumerations literals associated with a
	 *			{@link #TYPE_ENUMERATION enumeration} type.
	 * 
	 * @see #TYPE_ENUMERATION
	 */
	public String[] getEnumerationLiterals()
	{
		return this.enumerationLiterals;
	}

	/**
	 * The value class name associated with a variable.
	 * 
	 * @return	The value class name associated with a
	 *			variable.
	 * 
	 */
	public String getSuggestedClassName()
	{
		return className;
	}

}
