/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Execution Result</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getTestVersion <em>Test Version</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getVerdict <em>Verdict</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getDeployment <em>Deployment</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getExecutionHistory <em>Execution History</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getInvocationExecutionEvent <em>Invocation Execution Event</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getTest <em>Test</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFExecutionResultImpl extends CMNNamedElementImpl implements TPFExecutionResult
{
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static final String copyright = "";

    /**
     * The default value of the '{@link #getTestVersion() <em>Test Version</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getTestVersion()
     * @generated
     * @ordered
     */
	protected static final String TEST_VERSION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getTestVersion() <em>Test Version</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getTestVersion()
     * @generated
     * @ordered
     */
	protected String testVersion = TEST_VERSION_EDEFAULT;

    /**
     * The default value of the '{@link #getVerdict() <em>Verdict</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getVerdict()
     * @generated
     * @ordered
     */
	protected static final TPFVerdict VERDICT_EDEFAULT = TPFVerdict.INCONCLUSIVE_LITERAL;

    /**
     * The cached value of the '{@link #getVerdict() <em>Verdict</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getVerdict()
     * @generated
     * @ordered
     */
	protected TPFVerdict verdict = VERDICT_EDEFAULT;

    /**
     * The default value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
	protected static final String TYPE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
	protected String type = TYPE_EDEFAULT;

    /**
     * The cached value of the '{@link #getDeployment() <em>Deployment</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getDeployment()
     * @generated
     * @ordered
     */
	protected TPFDeployment deployment = null;

    /**
     * The cached value of the '{@link #getExecutionHistory() <em>Execution History</em>}' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getExecutionHistory()
     * @generated
     * @ordered
     */
	protected TPFExecutionHistory executionHistory = null;

    /**
     * The cached value of the '{@link #getTest() <em>Test</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getTest()
     * @generated
     * @ordered
     */
	protected TPFTest test = null;

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected TPFExecutionResultImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EClass eStaticClass()
    {
        return Common_TestprofilePackage.eINSTANCE.getTPFExecutionResult();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String getTestVersion()
    {
        return testVersion;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setTestVersion(String newTestVersion)
    {
        String oldTestVersion = testVersion;
        testVersion = newTestVersion;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST_VERSION, oldTestVersion, testVersion));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TPFVerdict getVerdict()
    {
        return verdict;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setVerdict(TPFVerdict newVerdict)
    {
        TPFVerdict oldVerdict = verdict;
        verdict = newVerdict == null ? VERDICT_EDEFAULT : newVerdict;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__VERDICT, oldVerdict, verdict));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String getType()
    {
        return type;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setType(String newType)
    {
        String oldType = type;
        type = newType;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__TYPE, oldType, type));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TPFDeployment getDeployment()
    {
        if (deployment != null && deployment.eIsProxy())
        {
            TPFDeployment oldDeployment = deployment;
            deployment = (TPFDeployment)eResolveProxy((InternalEObject)deployment);
            if (deployment != oldDeployment)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_TestprofilePackage.TPF_EXECUTION_RESULT__DEPLOYMENT, oldDeployment, deployment));
            }
        }
        return deployment;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TPFDeployment basicGetDeployment()
    {
        return deployment;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setDeployment(TPFDeployment newDeployment)
    {
        TPFDeployment oldDeployment = deployment;
        deployment = newDeployment;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__DEPLOYMENT, oldDeployment, deployment));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TPFExecutionHistory getExecutionHistory()
    {
        return executionHistory;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetExecutionHistory(TPFExecutionHistory newExecutionHistory, NotificationChain msgs)
    {
        TPFExecutionHistory oldExecutionHistory = executionHistory;
        executionHistory = newExecutionHistory;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY, oldExecutionHistory, newExecutionHistory);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setExecutionHistory(TPFExecutionHistory newExecutionHistory)
    {
        if (newExecutionHistory != executionHistory)
        {
            NotificationChain msgs = null;
            if (executionHistory != null)
                msgs = ((InternalEObject)executionHistory).eInverseRemove(this, Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_RESULT, TPFExecutionHistory.class, msgs);
            if (newExecutionHistory != null)
                msgs = ((InternalEObject)newExecutionHistory).eInverseAdd(this, Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_RESULT, TPFExecutionHistory.class, msgs);
            msgs = basicSetExecutionHistory(newExecutionHistory, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY, newExecutionHistory, newExecutionHistory));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TPFInvocationEvent getInvocationExecutionEvent()
    {
        if (eContainerFeatureID != Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT) return null;
        return (TPFInvocationEvent)eContainer;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setInvocationExecutionEvent(TPFInvocationEvent newInvocationExecutionEvent)
    {
        if (newInvocationExecutionEvent != eContainer || (eContainerFeatureID != Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT && newInvocationExecutionEvent != null))
        {
            if (EcoreUtil.isAncestor(this, newInvocationExecutionEvent))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eContainer != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newInvocationExecutionEvent != null)
                msgs = ((InternalEObject)newInvocationExecutionEvent).eInverseAdd(this, Common_TestprofilePackage.TPF_INVOCATION_EVENT__INVOKED_EXECUTION_RESULT, TPFInvocationEvent.class, msgs);
            msgs = eBasicSetContainer((InternalEObject)newInvocationExecutionEvent, Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT, newInvocationExecutionEvent, newInvocationExecutionEvent));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TPFTest getTest()
    {
        if (test != null && test.eIsProxy())
        {
            TPFTest oldTest = test;
            test = (TPFTest)eResolveProxy((InternalEObject)test);
            if (test != oldTest)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST, oldTest, test));
            }
        }
        return test;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TPFTest basicGetTest()
    {
        return test;
    }

	/**
	 * This setter has an additional side effect of setting the this.type to
	 * the same String as newTest.getType()  It delegates the actual setTest work
	 * to the EMF generated setter method (leveraging the EMF naming convention
	 * to xxxGen(), EMF will continue to update the generated method that ends with 
	 * Gen, and will not overwrite this method.)
	 *     
	 * @see org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#setTest(org.eclipse.hyades.models.common.testprofile.TPFTest)
	 */
	public void setTest(TPFTest newTest) {
		setTestGen(newTest);
		if ( newTest != null )
		{
			type = newTest.getType();
		}
	}
	
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setTestGen(TPFTest newTest)
    {
        TPFTest oldTest = test;
        test = newTest;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST, oldTest, test));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY:
                    if (executionHistory != null)
                        msgs = ((InternalEObject)executionHistory).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY, null, msgs);
                    return basicSetExecutionHistory((TPFExecutionHistory)otherEnd, msgs);
                case Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY:
                    return basicSetExecutionHistory(null, msgs);
                case Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT:
                    return eBasicSetContainer(null, Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
    {
        if (eContainerFeatureID >= 0)
        {
            switch (eContainerFeatureID)
            {
                case Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT:
                    return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_INVOCATION_EVENT__INVOKED_EXECUTION_RESULT, TPFInvocationEvent.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__ID:
                return getId();
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__DESCRIPTION:
                return getDescription();
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__NAME:
                return getName();
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST_VERSION:
                return getTestVersion();
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__VERDICT:
                return getVerdict();
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TYPE:
                return getType();
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__DEPLOYMENT:
                if (resolve) return getDeployment();
                return basicGetDeployment();
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY:
                return getExecutionHistory();
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT:
                return getInvocationExecutionEvent();
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST:
                if (resolve) return getTest();
                return basicGetTest();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eSet(EStructuralFeature eFeature, Object newValue)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__ID:
                setId((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__DESCRIPTION:
                setDescription((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__NAME:
                setName((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST_VERSION:
                setTestVersion((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__VERDICT:
                setVerdict((TPFVerdict)newValue);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TYPE:
                setType((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__DEPLOYMENT:
                setDeployment((TPFDeployment)newValue);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY:
                setExecutionHistory((TPFExecutionHistory)newValue);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT:
                setInvocationExecutionEvent((TPFInvocationEvent)newValue);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST:
                setTest((TPFTest)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eUnset(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__ID:
                setId(ID_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__DESCRIPTION:
                setDescription(DESCRIPTION_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__NAME:
                setName(NAME_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST_VERSION:
                setTestVersion(TEST_VERSION_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__VERDICT:
                setVerdict(VERDICT_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TYPE:
                setType(TYPE_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__DEPLOYMENT:
                setDeployment((TPFDeployment)null);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY:
                setExecutionHistory((TPFExecutionHistory)null);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT:
                setInvocationExecutionEvent((TPFInvocationEvent)null);
                return;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST:
                setTest((TPFTest)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean eIsSet(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__ID:
                return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__DESCRIPTION:
                return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST_VERSION:
                return TEST_VERSION_EDEFAULT == null ? testVersion != null : !TEST_VERSION_EDEFAULT.equals(testVersion);
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__VERDICT:
                return verdict != VERDICT_EDEFAULT;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TYPE:
                return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__DEPLOYMENT:
                return deployment != null;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY:
                return executionHistory != null;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT:
                return getInvocationExecutionEvent() != null;
            case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST:
                return test != null;
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (testVersion: ");
        result.append(testVersion);
        result.append(", verdict: ");
        result.append(verdict);
        result.append(", type: ");
        result.append(type);
        result.append(')');
        return result.toString();
    }

} //TPFExecutionResultImpl
