/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.impl;
import java.util.Hashtable;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
/**
 *
 */
public class Outputter extends ProcessUnit implements IOutputter
{
	/**
	  * @see org.eclipse.hyades.logging.adapter.IComponent#update()
	 */
	public void update() throws AdapterInvalidConfig
	{
		super.update();
		
		Element element = getConfiguration();

		// Get outputter properties from the outputter configuration
		Element outputterProperty;
		Element outputterNode;
		String propertyName = null;
		String propertyValue = null;
		if (getProperties() == null)
			setProperties(new Hashtable());
			
		Hashtable outputterProperties = getProperties();	
		NodeList outputterNodes = element.getChildNodes();
		for (int i = 0; i < outputterNodes.getLength(); i++) {
			if (outputterNodes.item(i).getNodeType() == Node.ELEMENT_NODE) {
				outputterNode = (Element) outputterNodes.item(i);

				/* If a generic outputter type was used to specifiy the outputter then get the properties that are
				 * subelements.
				 */
				if (outputterNode.getTagName().equals(Messages.getString("HyadesGAGenericOutputterTagName"))) {
					// Get the children
					NodeList propertyNodes = outputterNode.getChildNodes();
					for (int j = 0; j < propertyNodes.getLength(); j++) {
						if (propertyNodes.item(j).getNodeType() == Node.ELEMENT_NODE) {
							outputterProperty = (Element) propertyNodes.item(j);
							// Get the outputter parameter from the outputter property element			
							// get name and value from property and add the property to the hash table.
							if (outputterProperty.hasAttribute(Messages.getString("HyadesGAOutputterPropertyNameTag")))
								propertyName = outputterProperty.getAttribute(Messages.getString("HyadesGAOutputterPropertyNameTag"));
			
							if (outputterProperty.hasAttribute(Messages.getString("HyadesGAOutputterPropertyValueTag")))
								propertyValue = outputterProperty.getAttribute(Messages.getString("HyadesGAOutputterPropertyValueTag"));
								
							if (propertyName != null &&	propertyName.length() > 0 &&
								propertyValue != null && propertyValue.length() > 0) {
									
								outputterProperties.put(propertyName, propertyValue);																	
							}
						}
					}
				}
			}
		}
	}
}
