/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.impl;
import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IProcessUnit;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
/**
 *
 */
public class ProcessUnit extends Component implements IProcessUnit
{
	private Hashtable properties = null;
	protected boolean flushingMode = false;
	/**
	 * @see org.eclipse.hyades.logging.adapter.IProcessUnit#processEventItems(Object[])
	 */
	public Object[] processEventItems(Object[] msgs)
	{
		// processEventItems should be overridden by any serious Component
	    CommonBaseEvent event = getEventFactory().createCommonBaseEvent();

	    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_ProcessUnit_ERROR_");
	    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{getUniqueID()});							    

	    event.setSeverity(CommonBaseEvent.SEVERITY_FATAL);

	    log(event);
		
		return null;
	}
	/**
	 * flushEventItems should be overridden by any Component that buffers data
	 * @see org.eclipse.hyades.logging.adapter.IProcessUnit#flushEventItems(java.lang.Object[])
	 */
	public Object[] flushEventItems(Object[] msgs)
	{
		flushingMode = true;
		Object[] temp = processEventItems(msgs);
		flushingMode = false;
		return temp;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IProcessUnit#processEventItem(Object[])
	 */
	public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig
	{
		return null;
	}
	
	/**
	  * @see org.eclipse.hyades.logging.adapter.IComponent#update()
	 */
	public void update() throws AdapterInvalidConfig
	{
		super.update();
		Element element = getConfiguration();
						
		// Get sensor properties from the sensor configuration
		Element sensorProperty;
		Element sensorNode;
		String propertyName = null;
		String propertyValue = null;
		properties = new Hashtable();
		NodeList sensorNodes = element.getChildNodes();
		for (int i = 0; i < sensorNodes.getLength(); i++) {
			if (sensorNodes.item(i).getNodeType() == Node.ELEMENT_NODE) {
				sensorNode = (Element) sensorNodes.item(i);
				/* If the sensor parameters are in sensor properties then get the property */
				if (sensorNode.getTagName().equals(Messages.getString("HyadesGAPropertyTagName"))) {
					// Get the sensor parameter from the sensor property element			
					sensorProperty = sensorNode;
					// get name and value from property and add the property to the hash table.
					if (sensorProperty.hasAttribute(Messages.getString("HyadesGAPropertyNameTag")))
						propertyName = sensorProperty.getAttribute(Messages.getString("HyadesGAPropertyNameTag"));
	
					if (sensorProperty.hasAttribute(Messages.getString("HyadesGAPropertyValueTag")))
						propertyValue = sensorProperty.getAttribute(Messages.getString("HyadesGAPropertyValueTag"));
						
					if (propertyName != null &&	propertyName.length() > 0 &&
						propertyValue != null && propertyValue.length() > 0) {
							
						properties.put(propertyName, propertyValue);		
					}
				}
			}
		}
	}

	/**
	 * @return
	 */
	public Hashtable getProperties() {
		return properties;
	}

	/**
	 * @param hashtable
	 */
	public void setProperties(Hashtable hashtable) {
		properties = hashtable;
	}

}
