/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.hyades.test.common.util.BaseString;

public class RemoteAppResourceBundle 
{
	private static RemoteAppResourceBundle instance;
	private ResourceBundle resourceBundle;
	
	RemoteAppResourceBundle()
	{
		this.resourceBundle = ResourceBundle.getBundle("remoteapp");
	}
	
	public static void initialize()
	{
		instance = new RemoteAppResourceBundle();
	}
	
	public ResourceBundle getResourceBundle()
	{		
		return resourceBundle;
	}	

	public static String getString(String key)
	throws MissingResourceException
	{
		if(instance.getResourceBundle() == null)
			return key;
			
		return instance.getResourceBundle().getString(key);
	}
	
	public static String getString(String key, String arg)
	throws MissingResourceException
	{
		if(instance.getResourceBundle() == null)
			return key;

		return BaseString.replace(getString(key), "%1", arg);
	}	

	public static String getString(String key, String[] args)
	throws MissingResourceException
	{
		if(instance.getResourceBundle() == null)
			return key;
		
		String value = getString(key);
		for(int i = 0, max = args.length; i < max; i++)
		{
			String arg = args[i];
			if(arg.startsWith("%") && (arg.length() > 0))
				arg = getString(arg.substring(1));
			value = BaseString.replace(value,"%"+Integer.toString(i+1), arg);
		}
		
		return value;	
	}
}
