/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.ArrayList;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.wizard.*;
import org.eclipse.hyades.ui.extension.*;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.dialogs.PropertyDialogAction;

/**
 * Group action for the Trace Navigator.
 * 
 * <p>This implementation is based on the 
 * {@link org.eclipse.ui.views.navigator.MainActionGroup} class.
 * 
 */
public class TraceNavigatorActionGroup extends TraceLogActionGroup
{

	protected OpenWizardAction fOpenMonitorAction;	
	protected OpenWizardAction fOpenProfAgentAction;
	protected PropertyDialogAction fPropertyDialogAction;
	protected OpenWizardAction fOpenProcessAction;	
	
	/**
	 * Constructor for NavigatorActionGroup
	 * @param testNavigator
	 */
	public TraceNavigatorActionGroup(INavigator viewer)
	{
		super(viewer);
	}
	
	/**
	 * @see org.eclipse.ui.actions.ActionGroup#dispose()
	 */
	public void dispose()
	{	
		deleteActions();
		super.dispose();
	}
		
		
		private void deleteActions()
		{
		
			if (fOpenMonitorAction != null)
			{
				fOpenMonitorAction.dispose();
				fOpenMonitorAction = null;
			}
			if (fOpenProcessAction != null)
			{
				fOpenProcessAction.dispose();
				fOpenProcessAction = null;
			}
			if (fPropertyDialogAction != null)
			{
				fPropertyDialogAction.dispose();
				fPropertyDialogAction = null;
			}
			
			if (fOpenProfAgentAction != null)
			{
				fOpenProfAgentAction.dispose();
				fOpenProfAgentAction = null;
			}
	}

	/**
	 * @see org.eclipse.ui.actions.ActionGroup#setContext(org.eclipse.ui.actions.ActionContext)
	 */
	public void setContext(ActionContext context)
	{
		super.setContext(context);
		/*
		sorterActionGroup.setContext(context);
		newActionGroup.setContext(context);
		workingSetFilterActionGroup.setContext(context);
		frameListActionGroup.setContext(context); 
		*/
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup#createActions()
	 */
	protected void createActions()
	{
		super.createActions();
				
		fNewSnapshotGrp = new Separator(TraceConstants.PROFILE_NEW_SNAPSHOT_GROUP);
		fGCGroup = new Separator(TraceConstants.PROFILE_GC_GROUP);
		
		fTerminateGrp = new Separator(TraceConstants.PROFILE_TERMINATE_GROUP);
		
		fSaveToFile = new SaveAction(getNavigator());
	
		fOpenMonitorAction =
			new OpenWizardAction(
		(PDProjectExplorer)getNavigator(),
				OpenMonitorWizard.class,
				UIPlugin.getResourceString("PROPERTIES"));
		fOpenProfAgentAction =
			new OpenWizardAction(
		(PDProjectExplorer)getNavigator(),
				OpenProfAgentWizard.class,
				UIPlugin.getResourceString("PROPERTIES"));
		fOpenProcessAction =
			new OpenWizardAction(
		(PDProjectExplorer)getNavigator(),
				OpenProcessWizard.class,
				UIPlugin.getResourceString("PROPERTIES"));
	
		fDeleteAction = new DeleteAction(getNavigator());
		fPropertyDialogAction = new PropertyDialogAction(getNavigator().getViewSite().getShell(), getNavigator().getViewer());
	}

	/**
	 * @see org.eclipse.ui.actions.ActionGroup#fillContextMenu(org.eclipse.jface.action.IMenuManager)
	 */
	public void fillContextMenu(IMenuManager menu)
	{
		super.fillContextMenu(menu);
		
		IStructuredSelection selection = (IStructuredSelection)getContext().getSelection();
		boolean sameClass = false;
		boolean multiSelection = (selection.size() > 1);
		if (multiSelection)
			sameClass = areSameClass(selection);
				
		if (selection.isEmpty()) {
			fImportActionGroup.fillContextMenu(menu);
			menu.appendToGroup(INavigatorContribution.GROUP_REFRESH,fRefreshTree);
			return;
		}
		
		Object sel = selection.iterator().next();
		updateActions(selection);

		if(sel instanceof TRCMonitor)
		{
			menu.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, new Separator(GROUP_ADD_VIEWS));		
			addViews(menu, sel);
			menu.appendToGroup(INavigatorContribution.GROUP_REFRESH, fRefreshGrp);
		}
		else if(sel instanceof TRCNode)
		{
			menu.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, new Separator(GROUP_ADD_VIEWS));		
			addViews(menu, sel); 
			menu.appendToGroup(INavigatorContribution.GROUP_REFRESH, fRefreshGrp);
		}
		else if(sel instanceof TRCProcessProxy)
		{
			if (!multiSelection) {
				menu.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, fGCGroup);
				menu.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, fTerminateGrp);
				
				menu.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, new Separator(GROUP_ADD_VIEWS));		
				addViews(menu, sel);
				menu.appendToGroup(INavigatorContribution.GROUP_REFRESH, fRefreshGrp);
				
			}
	    	
		}
		else if(sel instanceof TRCAgentProxy)
		{
			if (!multiSelection || sameClass) {
				menu.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, fMonitorGrp);
				menu.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, fGCGroup);
				menu.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, fAttachGrp);				
			}
			
			if(!multiSelection)
			{
				menu.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, fNewSnapshotGrp);
				menu.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, fTerminateGrp);
				
				menu.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, new Separator(GROUP_ADD_VIEWS));		
				addViews(menu, sel);
				menu.appendToGroup(INavigatorContribution.GROUP_REFRESH, fRefreshGrp);
			}
	    	
		}
		else if (sel instanceof INavigatorItem ){
			if (!multiSelection) {
				menu.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, fMonitorGrp);
				menu.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, fGCGroup);
				menu.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, fAttachGrp);				
				menu.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, new Separator(GROUP_ADD_VIEWS));		
				addViews(menu, sel);
				menu.appendToGroup(INavigatorContribution.GROUP_REFRESH, fRefreshGrp);
			}
		}

		menu.appendToGroup(INavigatorContribution.GROUP_DELETE,fDeleteAction);
		menu.appendToGroup(INavigatorContribution.GROUP_SAVE,fSaveToFile);
		menu.appendToGroup(INavigatorContribution.GROUP_REFRESH,fRefreshTree);
		menu.appendToGroup(INavigatorContribution.GROUP_REFRESH,fRefreshLocal);

		if (!multiSelection) {
			
			if (fPropertyDialogAction.isApplicableForSelection())
				menu.appendToGroup(INavigatorContribution.GROUP_PROPERTIES,fPropertyDialogAction);
	
			if (sel instanceof TRCMonitor) {
				menu.appendToGroup(INavigatorContribution.GROUP_PROPERTIES,fOpenMonitorAction);
			} else if (sel instanceof TRCNode) {
				menu.appendToGroup(INavigatorContribution.GROUP_PROPERTIES,fOpenNodeAction);
			} else if (sel instanceof TRCProcessProxy) {
				menu.appendToGroup(INavigatorContribution.GROUP_PROPERTIES,fOpenProcessAction); 
			} else if (sel instanceof TRCAgentProxy) {
				if (((TRCAgentProxy) sel).getType().equals(TraceConstants.PROFILE_AGENT_TYPE)) {
					menu.appendToGroup(INavigatorContribution.GROUP_PROPERTIES,fOpenProfAgentAction);
				} else {
						menu.appendToGroup(INavigatorContribution.GROUP_PROPERTIES,fOpenLogAgentAction);
				}
			}
		}

		fImportActionGroup.fillContextMenu(menu);		
	}
	
	/**
	 * Insert the method's description here.
	 * Creation date: (08/24/2000 2:06:10 PM)
	 * @param menu com.ibm.jface.MenuManager
	 */
	protected void addViews(IMenuManager menu, Object obj) {
		
		if(obj == null || !((obj instanceof EObject) || (obj instanceof INavigatorItem)))
		  return;

		MenuManager popup = new MenuManager(UIPlugin.getResourceString("MENU_MANAGER"));
		menu.appendToGroup(GROUP_ADD_VIEWS,popup);
		  
		if(obj instanceof TRCMonitor)
		{
			TRCMonitor monitor = (TRCMonitor)obj;
			IAction[] actions = getViewMappingForType(TraceConstants.MONITOR_TYPE);
			for(int idx=0; idx<actions.length; idx++)
			{
				if(actions[idx] != null)
				   popup.add(actions[idx]);
			}
			
			ArrayList typesList = new ArrayList();
			EList nodes = monitor.getNodes();
			if(nodes.size() > 0)
			{ 
				for(int idx=0; idx<nodes.size(); idx++)
				{
					TRCNode node = (TRCNode) nodes.get(idx);
					
					EList processes = node.getProcessProxies();
					for(int i=0; i<processes.size(); i++)
					{
						TRCProcessProxy process = (TRCProcessProxy)processes.get(i);
						EList agents = process.getAgentProxies();
						
						for(int j=0; j<agents.size(); j++)
						{
							TRCAgentProxy agent = (TRCAgentProxy)agents.get(j);
							
							if(typesList.contains(agent.getType()))
							  continue; //actions already added to the popup
							
							typesList.add(agent.getType());
							actions = getViewMappingForType(agent.getType());
							if(actions.length > 0)
							{//add the actions to the popup
								popup.add(new Separator());								
								for(int k=0; k<actions.length; k++)
									popup.add(actions[k]);
							}
						}
					}
				}
			}
		}
		else if(obj instanceof TRCNode)
		{
			IAction[] actions = getViewMappingForType(TraceConstants.HOST_TYPE);
			for(int idx=0; idx<actions.length; idx++)
			{
				if(actions[idx] != null)
				   popup.add(actions[idx]);
			}
			
			ArrayList typesList = new ArrayList();
			EList processes = ((TRCNode) obj).getProcessProxies();
			for(int i=0; i<processes.size(); i++)
			{
				TRCProcessProxy process = (TRCProcessProxy)processes.get(i);
				EList agents = process.getAgentProxies();
				
				for(int j=0; j<agents.size(); j++)
				{
					TRCAgentProxy agent = (TRCAgentProxy)agents.get(j);
					
					if(typesList.contains(agent.getType()))
					  continue; //actions already added to the popup
					
					typesList.add(agent.getType());
					actions = getViewMappingForType(agent.getType());
					if(actions.length > 0)
					{//add the actions to the popup
						popup.add(new Separator());						
						for(int k=0; k<actions.length; k++)
							popup.add(actions[k]);
					}
				}
			}
			
		}
		else if(obj instanceof TRCProcessProxy)
		{
			ArrayList typesList = new ArrayList();
				EList agents = ((TRCProcessProxy)obj).getAgentProxies();
				
			for(int j=0; j<agents.size(); j++)
			{
				TRCAgentProxy agent = (TRCAgentProxy)agents.get(j);
				
				if(typesList.contains(agent.getType()))
				  continue; //actions already added to the popup
				
				typesList.add(agent.getType());
				IAction[] actions = getViewMappingForType(agent.getType());
				if(actions.length > 0)
				{//add the actions to the popup
					popup.add(new Separator());
					for(int k=0; k<actions.length; k++)
						popup.add(actions[k]);
				}
			}			
		}
		else if(obj instanceof TRCAgentProxy)
		{
			IAction[] actions = getViewMappingForType(((TRCAgentProxy)obj).getType());
			for(int idx=0; idx<actions.length; idx++)
			{
				if(actions[idx] != null)
				   popup.add(actions[idx]);
			}
		}
		else if (obj instanceof INavigatorItem)
		{
			IAction[] actions = getViewMappingForType(((INavigatorItem)obj).getType());
			for(int idx=0; idx<actions.length; idx++)
			{
				if(actions[idx] != null)
				   popup.add(actions[idx]);
			}
		}
	}

	/**
	 * Handles double clicks in viewer.
	 * Opens editor if file double-clicked.
	 */
	public void handleDoubleClick(DoubleClickEvent event) {
		
		IStructuredSelection s = (IStructuredSelection) event.getSelection();
		Object obj = s.getFirstElement();

		if(obj == null || !((obj instanceof EObject) || (obj instanceof INavigatorItem)))
		  return;

		if(obj instanceof TRCMonitor)
		{
			IAction[] actions = getViewMappingForType("Monitor");
			if(actions.length > 0 && actions[0] != null)
				actions[0].run();
		}
		else if(obj instanceof TRCNode)
		{
			IAction[] actions = getViewMappingForType("Host");
			if(actions.length > 0 && actions[0] != null)
				actions[0].run();
		}
		else if(obj instanceof TRCProcessProxy)
		{
			EList agents = ((TRCProcessProxy)obj).getAgentProxies();
			for(int idx=0; idx<agents.size(); idx++)
			{
				TRCAgentProxy agent = ((TRCAgentProxy)agents.get(idx));
				if(agent == null || agent.eIsProxy())
				  continue;
				  
				IAction[] actions = getViewMappingForType(agent.getType());
				if(actions.length > 0 && actions[0] != null)
				{
					actions[0].run();					
					return;
				}				  				 
			}
		}
		else if(obj instanceof TRCAgentProxy)
		{
			IAction[] actions = getViewMappingForType(((TRCAgentProxy)obj).getType());
			if(actions.length > 0 && actions[0] != null)
				actions[0].run();
		}
		else if(obj instanceof INavigatorItem)
		{
			IAction[] actions = getViewMappingForType(((INavigatorItem)obj).getType());
			if(actions.length > 0 && actions[0] != null)
				actions[0].run();
		}
	}

	/**
	 * Indicates that a property has changed.
	 * @see IPropertyListener
	 */
	public void propertyChanged(Object source, int propId)
	{
		//reset trace view actions
		if(source instanceof IAssociationMappingRegistry)
			traceViewsMap.clear();
	}
}
