/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.MonitorSelectionDialog;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.dialogs.*;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;

/*
* CONTEXT_ID tloc0001 for location entry field from trace location
*/
/*
* CONTEXT_ID tloc0002 for browse location button from trace location
*/
/*
* CONTEXT_ID tloc0003 for monitor entry field from trace location
*/
/*
* CONTEXT_ID tloc0004 for browse monitor button from trace location
*/

public class TraceLocationUI extends AbstractChangeable implements SelectionListener
{
	private Button _browseLocation;
	private Text   _location;
	private Text   _monitor;
	private Button _browseMonitor;
	private Label  _locationLabel;
/**
 * TraceOptionsUI constructor comment.
 */
public TraceLocationUI() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 3:45:54 PM)
 * @param parent com.ibm.swt.widgets.Composite
 */
public Composite createControl(Composite parent)
{
	GridLayout layout;
	GridData   data;
	
	Composite result = new Composite(parent, SWT.NULL);
	layout = new GridLayout();
	layout.numColumns = 3;
	layout.verticalSpacing=2;
	result.setLayout(layout);
	data = GridUtil.createHorizontalFill();
	result.setLayoutData(data);

	Listener modifyListener = new Listener() {
		public void handleEvent(Event event) {
			changed();
		}
	};
	
	_locationLabel = new Label(result, SWT.NULL);
	_locationLabel.setText(UIPlugin.getResourceString("STR_TRACE_LOCATION"));

	_location = new Text(result, SWT.BORDER);
	_location.setLayoutData(GridUtil.createHorizontalFill());
	_location.addListener(SWT.Modify, modifyListener);
	
	_browseLocation = new Button(result, SWT.NULL);
	_browseLocation.setText(UIPlugin.getResourceString("BROWSE"));
	
	Label desc = new Label(result, SWT.NULL);
	desc.setText(UIPlugin.getResourceString("STR_MON_LOCATION"));

	_monitor = new Text(result, SWT.BORDER);
	_monitor.setLayoutData(GridUtil.createHorizontalFill());
	_monitor.addListener(SWT.Modify, modifyListener);
	
	_browseMonitor = new Button(result, SWT.NULL);
	_browseMonitor.setText(UIPlugin.getResourceString("BROWSE1"));
		
	_browseLocation.addSelectionListener(this);
	_browseMonitor.addSelectionListener(this);	
	
	_location.setFocus();
	
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_location,
		UIPlugin.getPluginId()+".tloc0001");
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_browseLocation,
		UIPlugin.getPluginId()+".tloc0002");
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_monitor,
		UIPlugin.getPluginId()+".tloc0003");
	
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_browseMonitor,
		UIPlugin.getPluginId()+".tloc0004");
	
	initialize();	
    	
	return result;
}

public void initialize(){
	IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();	
	
	_location.setText(store.getString(TraceConstants.TRACE_PROJECT_NAME));
	_monitor.setText(store.getString(TraceConstants.TRACE_MONITOR_NAME));	

}

public Label getLocationLabel() {
	return _locationLabel;
}

/**
 * Insert the method's description here.
 * Creation date: (8/7/2001 12:07:29 PM)
 * @return java.lang.String
 */
public Text getLocation() {
	return _location;
}
/**
 * Insert the method's description here.
 * Creation date: (8/8/2001 3:15:44 PM)
 * @return org.eclipse.swt.widgets.Text
 */
public Text getMonitor() {
	return _monitor;
}
/**
 * Insert the method's description here.
 * Creation date: (8/7/2001 1:56:12 PM)
 * @param enable boolean
 */
public void setEnabled(boolean enable)
{
	_location.setEnabled(enable);
	_browseLocation.setEnabled(enable);

	_monitor.setEnabled(enable);
	_browseMonitor.setEnabled(enable);
}
/**
 * Insert the method's description here.
 * Creation date: (9/26/2001 1:54:33 PM)
 * @param enable boolean
 */
public void setEnabledBrowse(boolean enable) {

	_browseLocation.setEnabled(enable);
	_browseMonitor.setEnabled(enable);
}
/**
 * Insert the method's description here.
 * Creation date: (9/26/2001 1:52:48 PM)
 * @param enabled boolean
 */
public void setEnabledLocation(boolean enable) {

	_location.setEnabled(enable);
}
/**
 * Insert the method's description here.
 * Creation date: (8/7/2001 12:08:12 PM)
 * @param location java.lang.String
 */
public void setLocation(String location)
{
	_location.setText(location);
}
/**
 * Insert the method's description here.
 * Creation date: (8/8/2001 3:16:11 PM)
 * @param text java.lang.String
 */
public void setMonitor(String text)
{
	_monitor.setText(text);
}
/**
 * Insert the method's description here.
 * Creation date: (8/8/2001 3:43:13 PM)
 */
private void showMonitorsDialog()
{
	
	MonitorSelectionDialog dialog = new MonitorSelectionDialog(
		   UIPlugin.getActiveWorkbenchShell(), UIPlugin.getResourceString("STR_RES_DLG_MSG")
		   );

	if (dialog.open() == MonitorSelectionDialog.OK)
	{

		Object[] result = dialog.getResult();
		if (result != null && result.length == 1 && result[0] != null)
		{
			IPath path = (IPath) result[0];
			_monitor.setText(path.lastSegment());
			_location.setText(path.uptoSegment(path.segmentCount()-1).toOSString());
			
			_monitor.setFocus();	
		}
	}
}
/**
 * Insert the method's description here.
 * Creation date: (8/7/2001 12:06:04 PM)
 */
private void showResourceDialog()
{
	IPath path = new Path(_location.getText().trim());
	IResource res = UIPlugin.getPluginWorkbench().getRoot().findMember(path);
	IContainer cont = null;
	
	if(res != null && res.exists() && res instanceof IContainer)
	   cont = (IContainer)res;
	
	ContainerSelectionDialog dialog = new ContainerSelectionDialog(
		   UIPlugin.getActiveWorkbenchShell(), cont, true, UIPlugin.getResourceString("STR_RES_DLG_MSG")
		   );

	if (dialog.open() == ContainerSelectionDialog.OK)
	{
		Object[] result = dialog.getResult();
		if (result != null && result.length == 1 && result[0] != null)
		{
			_location.setText(((IPath)result[0]).toOSString());		
		}
		
		_location.setFocus();
	}
	
}

/**
 * Sent when default selection occurs in the control.
 * <p>
 * For example, on some platforms default selection occurs
 * in a List when the user double-clicks an item or types
 * return in a Text.
 * </p>
 *
 * @param e an event containing information about the default selection
 */
public void widgetDefaultSelected(SelectionEvent e)
{}
/**
 * Sent when selection occurs in the control.
 * <p>
 * For example, on some platforms selection occurs in
 * a List when the user selects an item or items.
 * </p>
 *
 * @param e an event containing information about the selection
 */
public void widgetSelected(SelectionEvent e)
{
	if(e.widget == _browseLocation)
	  showResourceDialog();
	else if(e.widget == _browseMonitor)
	  showMonitorsDialog();
}

}
