/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.*;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jdt.debug.ui.launchConfigurations.*;
import org.eclipse.jface.preference.*;

/**
 * @author znensi
 */
public class ProfileJavaProcessTabGroup extends AbstractLaunchConfigurationTabGroup
{
	public void createTabs(ILaunchConfigurationDialog dialog, String mode)
	{
		// check preferences whether profiling is enabled
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		boolean isProfilingEnabled = store.getBoolean(TraceConstants.PROF_OPTION_KEY);

		ArrayList tabs = new ArrayList(10);

		// agents tab is context sensitive; depends on host
		ProfileAgentsTab agents = new ProfileAgentsTab();
		tabs.add(new ProfileHostTab(agents));
		tabs.add(agents);

		if (isProfilingEnabled)
		{
			tabs.add(new ProfileTab(true));
		}

		tabs.add(new JavaSourceLookupTab());
		tabs.add(new CommonTab());

		AbstractLaunchConfigurationTab[] array = new AbstractLaunchConfigurationTab[tabs.size()];
		tabs.toArray(array);
		setTabs(array);
	}
	
	/*
	 * #57343 - Our tab groups need to clear the launch configuration
	 * before applying any options, to ensure that options are
	 * properly removed.
	 */
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		try {
			Map map = configuration.getAttributes();
			map.clear();
			configuration.setAttributes(map);
		}
		catch (CoreException e) {
			HyadesUIPlugin.logError(e);
		}
		super.performApply(configuration);
	}
}

