/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.*;

/**
 * An element with differently typed properties.
 * Changing a property sends out a DomainEvent.
 */
public class FilterSetElement
{
    private String fName;
	private ArrayList fChildren;

		/**
	 * Initialize a new TestElement from the given data.
	 */
	public FilterSetElement(String name)
	{
		fName = name;
	}
		
	public String getName() {
		return fName;
	}
	
	public void setName(String name) {
		fName= name;
	}
	
	public ArrayList getChildren()
	{
		return fChildren;		
	}
	
	public void setChildren(ArrayList children)
	{
		fChildren = children;
	}
}
