/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.*;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.wizard.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;

public class OpenLogAgentWizard extends Wizard implements INewWizard
{
  protected TRCAgentProxy fAgent;
  protected INavigator fViewer;
  protected OpenLogAgentPage fPage;
   
public OpenLogAgentWizard()
  {
	  super();
  }  
  public void addPages()
  {
  	setWindowTitle(UIPlugin.getResourceString("STR_PROPERTIES"));	
	fPage = new OpenLogAgentPage("agentPage", fViewer);
	addPage(fPage);
  }    
/**
 * Insert the method's description here.
 * Creation date: (10/05/2000 4:33:24 PM)
 * @return com.ibm.etools.perftrace.TRCAgent
 */
public TRCAgentProxy getAgent() {
	return fAgent;
}
/**
 * Insert the method's description here.
 * Creation date: (10/05/2000 4:17:37 PM)
 * @return com.ibm.itp.core.api.resources.IResource
 */

  public void init(IWorkbench workbench, IStructuredSelection selection)
  {
	if (selection instanceof IStructuredSelection)
	{
	  Iterator enum = ((IStructuredSelection) selection).iterator();
	  if (enum.hasNext())
	  {
		Object obj = enum.next();
		if (obj instanceof TRCAgentProxy)
		  fAgent = (TRCAgentProxy) obj;
	  }
	}
	
	setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_AGENT_PROP));
  }  
  public boolean performFinish()
  {
	return fPage.finish();
  } 
   
  public void setViewer(INavigator viewer)
  {
	fViewer = viewer;
  }  
}
