/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.ClassInstanceStatisticPage;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.part.IPage;

public class ClassInstanceStatisticViewer
extends TraceViewer {
    protected Action _openSource;
    protected Action _percentMode;
    protected Action _printColumns;
    protected Action _deltaColumns;
    protected String _title = TraceUIPlugin.getString("STR_CLASS_INSTANCE_ST_TITLE");

    public TraceViewerPage createPage(EObject mofObject) {
        return new ClassInstanceStatisticPage(mofObject, this);
    }

    public void dispose() {
        Enumeration pages = this._pages.elements();
        while (pages.hasMoreElements()) {
            IPage page = (IPage)pages.nextElement();
            if (!(page instanceof ClassInstanceStatisticPage)) continue;
            ((ClassInstanceStatisticPage)page).dispose();
        }
        this._openSource = null;
        this._percentMode = null;
        this._printColumns = null;
        super.dispose();
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        String strShowDelta = TraceUIPlugin.getString("STR_ST_SHOW_DELTA_COLUMNS");
        this._deltaColumns = new Action(strShowDelta){

            public void run() {
                ClassInstanceStatisticPage page = (ClassInstanceStatisticPage)ClassInstanceStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.getView().getDeltaColumnsAction().run();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._deltaColumns.setText(strShowDelta);
        TracePluginImages.setImageDescriptors((IAction)this._deltaColumns, "lcl16", "delta_show.gif");
        this._deltaColumns.setDescription(strShowDelta);
        this._deltaColumns.setToolTipText(strShowDelta);
        this._deltaColumns.setEnabled(true);
        String strShowPercent = TraceUIPlugin.getString("SHOW_PERCENT");
        this._percentMode = new Action(strShowPercent){

            public void run() {
                ClassInstanceStatisticPage page = (ClassInstanceStatisticPage)ClassInstanceStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.getView().getShowPercentAction().run();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._percentMode.setText(strShowPercent);
        TracePluginImages.setImageDescriptors((IAction)this._percentMode, "lcl16", "percentage_show.gif");
        this._percentMode.setDescription(strShowPercent);
        this._percentMode.setToolTipText(strShowPercent);
        this._percentMode.setEnabled(true);
        String strPrintColumns = TraceUIPlugin.getString("STR_ST_PRINT_COL");
        this._printColumns = new Action(strPrintColumns){

            public void run() {
                ClassInstanceStatisticPage page = (ClassInstanceStatisticPage)ClassInstanceStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.getView().getPrintColumnsAction().run();
            }
        };
        this._printColumns.setText(strPrintColumns);
        TracePluginImages.setImageDescriptors((IAction)this._printColumns, "lcl16", "choosecolumn_co.gif");
        this._printColumns.setDescription(strPrintColumns);
        this._printColumns.setToolTipText(strPrintColumns);
        this._printColumns.setEnabled(true);
        String openSourceStr = TraceUIPlugin.getString("STR_SOURCE");
        this._openSource = new Action(openSourceStr){

            public void run() {
                ClassInstanceStatisticPage page = (ClassInstanceStatisticPage)ClassInstanceStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(page.getMOFObject()).getFirstElement());
            }
        };
        this._openSource.setText(openSourceStr);
        TracePluginImages.setImageDescriptors((IAction)this._openSource, "tool16", "opensource_co.gif");
        this._openSource.setDescription(openSourceStr);
        this._openSource.setToolTipText(openSourceStr);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.removeAll();
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._openSource);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._percentMode);
        tbm.add((IAction)this._deltaColumns);
        tbm.add((IAction)this._printColumns);
        tbm.add((IContributionItem)new Separator());
        this.getViewSite().getActionBars().updateActionBars();
    }

    public Action percentMode() {
        return this._percentMode;
    }

    public Action deltaColumns() {
        return this._deltaColumns;
    }

    public Action openSource() {
        return this._openSource;
    }

    public void setFocus() {
        ClassInstanceStatisticPage page = (ClassInstanceStatisticPage)this.getCurrentPage();
        if (page != null) {
            page.setFocus();
        }
    }

    public EObject getObjectToView(EObject selObject) {
        if (selObject == null) {
            return selObject;
        }
        if (selObject instanceof TRCProcessProxy) {
            int nbOfAgents = 0;
            TRCAgentProxy a = null;
            EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
            int idx = 0;
            while (idx < agents.size()) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (agent != null && !agent.eIsProxy() && agent.getType().equals("Profiler")) {
                    ++nbOfAgents;
                    a = agent;
                }
                ++idx;
            }
            if (nbOfAgents == 1) {
                return a;
            }
        }
        return selObject;
    }

    public String getViewTitle() {
        return this._title;
    }
}

