/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;

public class AssociationEngineImplTest
extends TestCase {
    AssociationEngine ae = null;

    public AssociationEngineImplTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ae = EventFactory.eINSTANCE.createAssociationEngine();
    }

    public void testValidate1() throws ValidationException {
        this.ae = EventFactory.eINSTANCE.createAssociationEngine();
        this.ae.setName("ae test");
        this.ae.setType("Type");
        this.ae.setId(Util.getAlphaString(64));
        this.ae.validate();
    }

    public void testRequiredAttributes() throws ValidationException {
        this.ae.setName("ae test");
        this.ae.setType("Type");
        this.ae.setId(Util.getAlphaString(64));
        this.ae.validate();
        this.ae = EventFactory.eINSTANCE.createAssociationEngine();
        Util.assertMissingAttributes(this.ae, "all");
        this.ae.setName("ae test");
        this.ae.setType("Type");
        Util.assertMissingAttributes(this.ae, "id");
        this.ae = EventFactory.eINSTANCE.createAssociationEngine();
        this.ae.setName("ae test");
        this.ae.setId(Util.getAlphaString(64));
        Util.assertMissingAttributes(this.ae, "type");
        this.ae = EventFactory.eINSTANCE.createAssociationEngine();
        this.ae.setType("Type");
        this.ae.setId(Util.getAlphaString(64));
        Util.assertMissingAttributes(this.ae, "name");
    }

    public void testInvalidAttributes() {
        this.ae.setName(Util.getAlphaString(64));
        this.ae.setType(Util.getAlphaString(64));
        this.ae.setId(Util.getAlphaString(64));
        Util.assertValidBoundaries(this.ae);
        this.ae.setName(Util.getAlphaString(65));
        Util.assertInvalidBoundaries(this.ae, "name");
        this.ae.setName(Util.getAlphaString(64));
        this.ae.setType(Util.getAlphaString(65));
        Util.assertInvalidBoundaries(this.ae, "type");
        this.ae.setType(Util.getAlphaString(64));
        this.ae.setId(Util.getAlphaString(65));
        try {
            this.ae.validate();
            Assert.fail((String)"id too long");
        }
        catch (ValidationException validationException) {
            Util.assertExceptionId("IWAT0206E", validationException);
        }
    }

    public void testToString() {
        String string = "my name";
        String string2 = "my type";
        String string3 = "my id";
        this.ae = EventFactory.eINSTANCE.createAssociationEngine();
        Assert.assertNotNull((String)"empty ae", (Object)this.ae.toString());
        this.ae.setName(string);
        this.ae.setType(string2);
        this.ae.setId(string3);
        Assert.assertNotNull((String)"ae with soma data filled in", (Object)this.ae.toString());
    }

    public void testGetSet() throws ValidationException {
        String string = "my name";
        String string2 = "my type";
        String string3 = "my id";
        this.ae = EventFactory.eINSTANCE.createAssociationEngine();
        this.ae.setName(string);
        this.ae.setType(string2);
        this.ae.setId(string3);
        Assert.assertEquals((String)string, (String)this.ae.getName());
        Assert.assertEquals((String)string2, (String)this.ae.getType());
        Assert.assertEquals((String)string3, (String)this.ae.getId());
    }

    public void testEquals() {
        AssociationEngine associationEngine = EventFactory.eINSTANCE.createAssociationEngine();
        associationEngine.setName("ae test");
        associationEngine.setType("Type");
        associationEngine.setId("AE345678901234567890123456789012");
        AssociationEngine associationEngine2 = EventFactory.eINSTANCE.createAssociationEngine();
        associationEngine2.setName("ae test");
        associationEngine2.setType("Type");
        associationEngine2.setId("A2345678901234567890123456789012");
        AssociationEngine associationEngine3 = (AssociationEngine)Util.clone(associationEngine);
        Assert.assertEquals((Object)associationEngine, (Object)associationEngine3);
        AssociationEngine associationEngine4 = (AssociationEngine)Util.clone(associationEngine2);
        Assert.assertEquals((Object)associationEngine2, (Object)associationEngine4);
        Assert.assertFalse((boolean)associationEngine.equals(associationEngine2));
    }
}

