/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.util.Iterator;
import org.eclipse.hyades.loaders.trace.CallStackPerThread;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCThread;

public class TraceMethodBaseLoader
extends TraceXMLFragmentLoader {
    protected static final String TICKET = "ticket";
    protected static final String STACK_DEPTH = "stackDepth";
    protected CallStackPerThread cs;
    protected TraceUtils.InvocationPool invocationPool;
    protected TRCClass invokerClass;
    protected TRCClass invokerObjectClass;
    protected TRCFullMethodInvocation fullInvocation;
    protected TRCFullMethodInvocation fullInvoker;
    protected TRCFullTraceObject invokerObject;
    protected TRCMethod invokerMethod;
    protected double deltaBaseTime;
    protected double lastChildExitTime;
    protected double previousSiblingExitTime;
    protected long ticket;
    protected short stackDepth;

    protected void updateTimeStatistics() {
        this.invokerMethod.setBaseTime(this.invokerMethod.getBaseTime() + this.deltaBaseTime);
        if (this.invokerObject != null) {
            this.invokerObject.setBaseTime(this.invokerObject.getBaseTime() + this.deltaBaseTime);
            if (this.invokerObjectClass != null) {
                this.invokerObjectClass.setInheritedBaseTime(this.invokerObjectClass.getInheritedBaseTime() + this.deltaBaseTime);
                this.invokerObjectClass.getPackage().setInheritedBaseTime(this.invokerObjectClass.getPackage().getInheritedBaseTime() + this.deltaBaseTime);
                this.invokerObjectClass.getPackage().getProcess().setInheritedBaseTime(this.invokerObjectClass.getPackage().getProcess().getInheritedBaseTime() + this.deltaBaseTime);
            }
        }
        this.invokerClass.setBaseTime(this.invokerClass.getBaseTime() + this.deltaBaseTime);
        this.invokerClass.getPackage().setBaseTime(this.invokerClass.getPackage().getBaseTime() + this.deltaBaseTime);
        this.invokerClass.getPackage().getProcess().setBaseTime(this.invokerClass.getPackage().getProcess().getBaseTime() + this.deltaBaseTime);
        Iterator stackIter = this.cs.iterator();
        while (stackIter.hasNext()) {
            TRCClass objectClass;
            TraceUtils.InvocationInfo invocationInfo = (TraceUtils.InvocationInfo)stackIter.next();
            if (!invocationInfo.isObjectLocked()) {
                TRCFullTraceObject obj = invocationInfo.getObject();
                obj.setCumulativeTime(obj.getCumulativeTime() + this.deltaBaseTime);
            }
            if ((objectClass = invocationInfo.getObjectClass()) != null && !invocationInfo.isObjectClassLocked()) {
                objectClass.setInheritedCumulativeTime(objectClass.getInheritedCumulativeTime() + this.deltaBaseTime);
                objectClass.getPackage().setInheritedCumulativeTime(objectClass.getPackage().getInheritedCumulativeTime() + this.deltaBaseTime);
                objectClass.getPackage().getProcess().setInheritedCumulativeTime(objectClass.getPackage().getProcess().getInheritedCumulativeTime() + this.deltaBaseTime);
            }
            if (!invocationInfo.isMethodLocked()) {
                invocationInfo.getMethod().setCumulativeTime(invocationInfo.getMethod().getCumulativeTime() + this.deltaBaseTime);
            }
            if (invocationInfo.isClassLocked()) continue;
            this.invokerClass = invocationInfo.getTheClass();
            this.invokerClass.setCumulativeTime(this.invokerClass.getCumulativeTime() + this.deltaBaseTime);
            this.invokerClass.getPackage().setCumulativeTime(this.invokerClass.getPackage().getCumulativeTime() + this.deltaBaseTime);
            this.invokerClass.getPackage().getProcess().setCumulativeTime(this.invokerClass.getPackage().getProcess().getCumulativeTime() + this.deltaBaseTime);
        }
    }

    protected TRCClass getExtendedClass(TRCObject anObject, TRCClass aClass) {
        if (anObject != null && anObject.getIsA() != aClass && anObject.getIsA() != this.theProcess.getClassClass()) {
            return anObject.getIsA();
        }
        return null;
    }

    protected void setMaxStackDepth(TRCThread theThread) {
        if (theThread == null) {
            return;
        }
        if (this.stackDepth > theThread.getMaxStackDepth()) {
            theThread.setMaxStackDepth(this.stackDepth);
        }
    }
}

