/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.hyades.trace.ui.internal.util.MonitorSelectionDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class PerfmonMainTab
extends AbstractLaunchConfigurationTab
implements ILaunchConfigurationTab,
SelectionListener,
KeyListener {
    ILaunchConfigurationDialog dialog;
    boolean isdirty = false;
    String message = null;
    String error_message = null;
    Composite mainpanel;
    Composite host_panel;
    Label rac_host_label;
    Text rac_host_text;
    Button reg_host_same;
    Text reg_host_text;
    Composite container_panel;
    Label container_label;
    Text container_text;
    Button container_browse;
    Composite monitor_panel;
    Label monitor_label;
    Text monitor_text;
    Button monitor_browse;

    public void setMessage(String msg) {
        this.message = msg;
        if (this.message.length() == 0) {
            this.message = null;
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setError(String msg) {
        this.error_message = msg;
        if (this.error_message.length() == 0) {
            this.error_message = null;
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setDirty(boolean b) {
        this.isdirty = b;
        this.checkForErrors();
        this.updateLaunchConfigurationDialog();
    }

    public void createControl(Composite parent) {
        GridLayout glayout = new GridLayout();
        glayout.numColumns = 1;
        this.mainpanel = new Composite(parent, 0);
        this.mainpanel.setLayout((Layout)glayout);
        glayout = new GridLayout();
        glayout.numColumns = 1;
        this.host_panel = new Composite(this.mainpanel, 0);
        this.host_panel.setLayout((Layout)glayout);
        this.host_panel.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.rac_host_label = new Label(this.host_panel, 16384);
        this.rac_host_label.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.rac_host_text = new Text(this.host_panel, 18436);
        this.rac_host_text.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.reg_host_same = new Button(this.host_panel, 32);
        this.reg_host_same.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.reg_host_text = new Text(this.host_panel, 18436);
        this.reg_host_text.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.rac_host_label.setText(PerfmonPlugin.getString("RAC_HOST"));
        this.rac_host_text.setText("?");
        this.reg_host_same.setText(PerfmonPlugin.getString("USE_RAC_HOST"));
        this.reg_host_text.setText("?");
        this.reg_host_same.setSelection(true);
        this.reg_host_text.setEnabled(false);
        glayout = new GridLayout();
        glayout.numColumns = 2;
        this.container_panel = new Composite(this.mainpanel, 0);
        this.container_panel.setLayout((Layout)glayout);
        this.container_panel.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.container_label = new Label(this.container_panel, 16384);
        this.container_label.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)2, (int)1, (int)4, (int)4));
        this.container_text = new Text(this.container_panel, 18436);
        this.container_text.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.container_browse = new Button(this.container_panel, 0);
        this.container_browse.setLayoutData((Object)GData.getGridData((boolean)false, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)1, (int)4));
        this.container_label.setText(PerfmonPlugin.getString("PROFILING_PROJECT"));
        this.container_text.setText("?");
        this.container_browse.setText(PerfmonPlugin.getString("BROWSE"));
        glayout = new GridLayout();
        glayout.numColumns = 2;
        this.monitor_panel = new Composite(this.mainpanel, 0);
        this.monitor_panel.setLayout((Layout)glayout);
        this.monitor_panel.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.monitor_label = new Label(this.container_panel, 16384);
        this.monitor_label.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)2, (int)1, (int)4, (int)4));
        this.monitor_text = new Text(this.container_panel, 18436);
        this.monitor_text.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.monitor_browse = new Button(this.container_panel, 0);
        this.monitor_browse.setLayoutData((Object)GData.getGridData((boolean)false, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)1, (int)4));
        this.monitor_label.setText(PerfmonPlugin.getString("PROFILING_MONITOR"));
        this.monitor_text.setText("DefaultMonitor");
        this.monitor_browse.setText(PerfmonPlugin.getString("BROWSE"));
        this.reg_host_same.addSelectionListener((SelectionListener)this);
        this.monitor_browse.addSelectionListener((SelectionListener)this);
        this.container_browse.addSelectionListener((SelectionListener)this);
        this.rac_host_text.addKeyListener((KeyListener)this);
        this.reg_host_text.addKeyListener((KeyListener)this);
        this.container_text.addKeyListener((KeyListener)this);
        this.monitor_text.addKeyListener((KeyListener)this);
        this.checkForErrors();
    }

    public void keyPressed(KeyEvent e) {
        this.setDirty(true);
    }

    public void keyReleased(KeyEvent e) {
        this.setDirty(true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.reg_host_same) {
            this.reg_host_text.setEnabled(!this.reg_host_text.getEnabled());
            this.setDirty(true);
        } else if (e.getSource() == this.monitor_browse) {
            Object[] result;
            MonitorSelectionDialog mdialog = new MonitorSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), PerfmonPlugin.getString("PROFILING_DIALOG"));
            if (mdialog.open() == 0 && (result = mdialog.getResult()) != null && result.length == 1 && result[0] != null) {
                IPath path = (IPath)result[0];
                URI monitor_uri = URI.createPlatformResourceURI((String)path.toString());
                this.monitor_text.setText(monitor_uri.toString().replaceFirst("platform:/resource/", ""));
                this.setDirty(true);
            }
        } else if (e.getSource() == this.container_browse) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Path container_savepath = null;
            IFolder container = null;
            try {
                container_savepath = new Path("" + this.container_text.getText());
                container = workspaceRoot.getFolder((IPath)container_savepath);
            }
            catch (Throwable x) {
                PerfmonPlugin.DBG.warning("could not find valid IContainer for model save path " + this.container_text.getText());
            }
            PerfmonPlugin.DBG.info("showing container selection dialog");
            ContainerSelectionDialog dialog = null;
            dialog = new ContainerSelectionDialog(this.mainpanel.getShell(), (IContainer)container, false, PerfmonPlugin.getString("SMODEL_SELECT_PATH_DESCRIPTION"));
            dialog.open();
            Object[] result = dialog.getResult();
            if (result != null && result.length > 0) {
                Path container_path = (Path)result[0];
                URI savepath = URI.createPlatformResourceURI((String)container_path.toString().replaceFirst("platform:/resource/", ""));
                this.container_text.setText("" + savepath);
                PerfmonPlugin.DBG.info("updating menuitems to reflect new model save path");
                this.setDirty(true);
            }
        }
    }

    public Control getControl() {
        return this.mainpanel;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("hosts_same", true);
        configuration.setAttribute("host_rac", "localhost");
        configuration.setAttribute("host_reg", "localhost");
        configuration.setAttribute("smodel_container", "");
        configuration.setAttribute("monitor", "DefaultMonitor");
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            String s = URI.createPlatformResourceURI((String)workspace.getRoot().getProjects()[0].getFullPath().toString()).toString();
            configuration.setAttribute("smodel_container", s);
        }
        catch (Exception e) {
            PerfmonPlugin.DBG.error("problem getting default project", (Throwable)e);
        }
        configuration.setAttribute("statcon_file", "");
        this.checkForErrors();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setDirty(false);
        try {
            this.reg_host_same.setSelection(configuration.getAttribute("hosts_same", true));
            this.rac_host_text.setText(configuration.getAttribute("host_rac", "localhost"));
            this.reg_host_text.setText(configuration.getAttribute("host_reg", "localhost"));
            this.container_text.setText(configuration.getAttribute("smodel_container", ""));
            this.monitor_text.setText(configuration.getAttribute("monitor", "DefaultMonitor"));
        }
        catch (CoreException e) {
            PerfmonPlugin.DBG.logVisibleError((Throwable)e, PerfmonPlugin.getString("ERROR_LAUNCH_CONFIG"), true);
        }
        if (this.reg_host_same.getSelection()) {
            this.reg_host_text.setEnabled(false);
        } else {
            this.reg_host_text.setEnabled(true);
        }
        this.checkForErrors();
    }

    public void dispose() {
        try {
            this.mainpanel.dispose();
        }
        catch (Throwable t) {}
    }

    private void printConfiguration(ILaunchConfiguration conf) {
        try {
            PerfmonPlugin.DBG.info("" + conf.getAttribute("hosts_same", true));
            PerfmonPlugin.DBG.info(conf.getAttribute("host_rac", "localhost"));
            PerfmonPlugin.DBG.info(conf.getAttribute("host_reg", "localhost"));
            PerfmonPlugin.DBG.info(conf.getAttribute("smodel_container", ""));
            PerfmonPlugin.DBG.info(conf.getAttribute("monitor", "DefaultMonitor"));
            PerfmonPlugin.DBG.info(conf.getAttribute("statcon_file", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.printConfiguration((ILaunchConfiguration)configuration);
        configuration.setAttribute("hosts_same", this.reg_host_same.getSelection());
        configuration.setAttribute("host_rac", this.rac_host_text.getText());
        configuration.setAttribute("host_reg", this.reg_host_text.getText());
        configuration.setAttribute("smodel_container", this.container_text.getText());
        configuration.setAttribute("monitor", this.monitor_text.getText());
    }

    public void checkForErrors() {
        this.error_message = "";
        try {
            if (this.rac_host_text.getText().length() == 0) {
                this.error_message = PerfmonPlugin.getString("BAD_RAC_HOST");
            }
            if (!this.reg_host_same.getSelection() && this.reg_host_text.getText().length() == 0) {
                this.error_message = PerfmonPlugin.getString("BAD_REG_HOST");
            }
            if (this.container_text.getText().length() == 0) {
                this.error_message = PerfmonPlugin.getString("BAD_CONTAINER");
            }
            if (this.monitor_text.getText().length() == 0) {
                this.error_message = PerfmonPlugin.getString("BAD_MONITOR");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setError(this.error_message);
        this.updateLaunchConfigurationDialog();
    }

    public String getErrorMessage() {
        return this.error_message;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.error_message == null;
    }

    public boolean canSave() {
        return this.isdirty;
    }

    protected ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.dialog;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        this.dialog = dialog;
    }

    public void launched(ILaunch launch) {
    }

    public String getName() {
        return PerfmonPlugin.getString("PERFMON_AGENT");
    }

    public Image getImage() {
        return PerfmonPlugin.img.getImage("logo.gif");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.initializeFrom((ILaunchConfiguration)workingCopy);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.performApply(workingCopy);
    }
}

