/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.model.statistical.SDView;
import org.eclipse.hyades.model.statistical.StatisticalFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.perfmon.StatisticalLoaderListener;
import org.eclipse.hyades.perfmon.xml.XMLParserListener;

public class StatisticalXMLTranslator
implements XMLParserListener {
    StatisticalFactory factory = StatisticalFactory.eINSTANCE;
    SDDescriptor root;
    HashMap idmap = new HashMap();
    HashMap descriptormap = new HashMap();
    SDDescriptor sdparent = null;
    SDDescriptor sd = null;
    SDSampleWindow window;
    boolean inside_description = false;
    ArrayList listeners = new ArrayList();

    public String getID(SDDescriptor counter) {
        return (String)this.descriptormap.get(counter);
    }

    public SDDescriptor getDescriptor(String id) {
        return (SDDescriptor)this.idmap.get(id);
    }

    public void addLoaderListener(StatisticalLoaderListener listener) {
        this.listeners.add(listener);
    }

    public void removeLoaderListener(StatisticalLoaderListener listener) {
        this.listeners.remove(listener);
    }

    public StatisticalXMLTranslator(TRCAgent agent, String name) {
        this.root = this.factory.createSDDescriptor();
        this.root.setName(name);
        this.root.setAgent(agent);
        this.window = this.getOrCreateView(agent);
    }

    public StatisticalXMLTranslator(SDDescriptor model) {
        this.root = model;
        this.window = this.getOrCreateView(model.getAgent());
    }

    private SDSampleWindow getOrCreateView(TRCAgent trcagent) {
        SDView view = (SDView)trcagent.getView();
        if (view == null) {
            view = this.factory.createSDView();
            view.setAgent(trcagent);
            view.setName("view");
        }
        if (view.eContents().size() == 0) {
            SDSampleWindow window = this.factory.createSDSampleWindow();
            window.setView(view);
            return window;
        }
        return (SDSampleWindow)view.eContents().get(0);
    }

    public SDDescriptor getModel() {
        return this.root;
    }

    private void modelChanged(SDDescriptor parent) {
        int i = 0;
        while (i < this.listeners.size()) {
            StatisticalLoaderListener listener = (StatisticalLoaderListener)this.listeners.get(i);
            listener.modelChanged(parent);
            ++i;
        }
    }

    public void startElement(String tag, HashMap h) throws Exception {
        if (tag.equals("description")) {
            this.inside_description = true;
            return;
        }
        if (tag.equals("RangeRepresentation")) {
            return;
        }
        if (tag.equals("GaugeRepresentation")) {
            return;
        }
        String id = null;
        String name = null;
        String parent = null;
        double time = 0.0;
        String value = null;
        String descriptor = null;
        if (tag.endsWith("Observation")) {
            time = Double.parseDouble((String)h.get("time"));
            value = (String)h.get("value");
            descriptor = (String)h.get("memberDescriptor");
            this.sd = (SDDescriptor)this.idmap.get(descriptor);
        }
        if (tag.endsWith("Descriptor")) {
            id = (String)h.get("id");
            name = (String)h.get("name");
            parent = (String)h.get("parent");
            if (id != null) {
                this.sd = (SDDescriptor)this.idmap.get(id);
                if (this.sd != null) {
                    return;
                }
            }
            if (parent != null) {
                this.sdparent = (SDDescriptor)this.idmap.get(parent);
            }
            if (parent == null || this.sdparent == null) {
                this.sdparent = this.root;
            }
        }
        if (tag.equals("Descriptor")) {
            if (this.sd == null) {
                this.sd = this.factory.createSDDescriptor();
                this.sd.setParent(this.sdparent);
                this.sd.setName(name);
                this.idmap.put(id, this.sd);
                this.descriptormap.put(this.sd, id);
                this.modelChanged(this.sdparent);
            }
        } else if (tag.equals("CounterDescriptor")) {
            if (this.sd == null) {
                this.sd = this.factory.createSDCounterDescriptor();
                this.sd.setParent(this.sdparent);
                this.sd.setName(name + " - " + id);
                this.idmap.put(id, this.sd);
                this.descriptormap.put(this.sd, id);
                this.modelChanged(this.sdparent);
            }
        } else if (tag.equals("SampleDescriptor")) {
            if (this.sd == null) {
                this.sd = this.factory.createSDSampleDescriptor();
                this.sd.setParent(this.sdparent);
                this.sd.setName(name);
                this.idmap.put(id, this.sd);
                this.descriptormap.put(this.sd, id);
                this.modelChanged(this.sdparent);
            }
        } else if (tag.equals("ContiguousObservation")) {
            SDMemberDescriptor mem = (SDMemberDescriptor)this.sd;
            EList list = mem.getSnapshotObservation();
            SDContiguousObservation obs = null;
            int i = 0;
            while (i < list.size()) {
                SDSnapshotObservation tmp = (SDSnapshotObservation)list.get(i);
                if (tmp instanceof SDContiguousObservation) {
                    obs = (SDContiguousObservation)tmp;
                    break;
                }
                ++i;
            }
            if (obs == null) {
                obs = this.factory.createSDContiguousObservation();
                obs.setMemberDescriptor(mem);
                obs.setWindow(this.window);
                list.add(obs);
                this.modelChanged((SDDescriptor)mem);
            }
            BasicEList times = (BasicEList)obs.getCreationTime();
            BasicEList values = (BasicEList)obs.getValue();
            times.addUnique((Object)new Double(time));
            values.addUnique((Object)new Double(value));
        } else if (tag.equals("DescreteObservation") || tag.equals("DiscreteObservation")) {
            SDMemberDescriptor mem = (SDMemberDescriptor)this.sd;
            EList list = mem.getSnapshotObservation();
            SDDiscreteObservation obs = null;
            int i = 0;
            while (i < list.size()) {
                SDSnapshotObservation tmp = (SDSnapshotObservation)list.get(i);
                if (tmp instanceof SDDiscreteObservation) {
                    obs = (SDDiscreteObservation)tmp;
                    break;
                }
                ++i;
            }
            if (obs == null) {
                obs = this.factory.createSDDiscreteObservation();
                obs.setMemberDescriptor(mem);
                obs.setWindow(this.window);
                list.add(obs);
                this.modelChanged((SDDescriptor)mem);
            }
            BasicEList times = (BasicEList)obs.getCreationTime();
            BasicEList values = (BasicEList)obs.getValue();
            times.addUnique((Object)new Double(time));
            values.addUnique((Object)new Integer((int)Double.parseDouble(value)));
        } else if (tag.equals("TextObservation")) {
            SDMemberDescriptor mem = (SDMemberDescriptor)this.sd;
            EList list = mem.getSnapshotObservation();
            SDTextObservation obs = null;
            int i = 0;
            while (i < list.size()) {
                SDSnapshotObservation tmp = (SDSnapshotObservation)list.get(i);
                if (tmp instanceof SDTextObservation) {
                    obs = (SDTextObservation)tmp;
                    break;
                }
                ++i;
            }
            if (obs == null) {
                obs = this.factory.createSDTextObservation();
                obs.setMemberDescriptor(mem);
                obs.setWindow(this.window);
                list.add(obs);
                this.modelChanged((SDDescriptor)mem);
            }
            BasicEList times = (BasicEList)obs.getCreationTime();
            BasicEList values = (BasicEList)obs.getTextValue();
            if (value == null) {
                throw new NullPointerException("null value for SDTextObservation");
            }
            times.addUnique((Object)new Double(time));
            values.addUnique((Object)value);
        }
    }

    public void endElement(String tag) throws Exception {
        if (tag.equals("description")) {
            this.inside_description = false;
            return;
        }
        if (tag.equals("RangeRepresentation")) {
            return;
        }
        if (tag.equals("GaugeRepresentation")) {
            return;
        }
    }

    public void startDocument() throws Exception {
    }

    public void endDocument() throws Exception {
    }

    public void text(String str) throws Exception {
        if (this.inside_description) {
            this.sd.setDescription(str);
        }
    }
}

