/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.IDetails;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditor;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;

public class SolutionDetails
extends Composite
implements IDetails,
Listener {
    private Text txtInfo;
    private CCombo cmbSolution;
    private ArrayList solutionRegistry = null;
    private SymptomDBEditor editor;
    private SDBFactoryImpl objFactory = null;
    private SDBSolution currentSel = null;
    private boolean isDisplaying = false;

    public SolutionDetails(RASWidgetFactory factory, Composite composite, int style) {
        super(composite, style);
        GridLayout solLayout = new GridLayout();
        solLayout.numColumns = 1;
        this.setLayout((Layout)solLayout);
        this.setLayoutData(GridUtil.createFill());
        Label lblSolution = factory.createLabel(this, SDbPlugin.getResourceString("STR_SOLUTION_LABEL"), 0);
        this.cmbSolution = factory.createCombo(this, 8);
        GridData cmbGrid = new GridData(768);
        cmbGrid.widthHint = 350;
        this.cmbSolution.setLayoutData((Object)cmbGrid);
        factory.createCompositeSeparator(this);
        Label lblInfo = factory.createLabel(this, SDbPlugin.getResourceString("STR_SI_DETAILS_LABEL"), 0);
        GridData lblInfoGrid = new GridData(768);
        lblInfo.setLayoutData((Object)lblInfoGrid);
        this.txtInfo = factory.createText(this, "", 770);
        GridData infoGrid = new GridData(1808);
        infoGrid.heightHint = 45;
        infoGrid.widthHint = 350;
        infoGrid.verticalSpan = 3;
        this.txtInfo.setLayoutData((Object)infoGrid);
        WorkbenchHelp.setHelp((Control)this.cmbSolution, (String)ContextIds.SYMDB_EDITOR_SOLUTION);
        WorkbenchHelp.setHelp((Control)this.txtInfo, (String)ContextIds.SYMDB_EDITOR_SOLUTION_DESCRIPTION);
        this.cmbSolution.addListener(13, (Listener)this);
        this.txtInfo.addListener(24, (Listener)this);
    }

    public void init(SymptomDBEditor editor) {
        this.editor = editor;
        this.objFactory = SDbPlugin.getDefault().getSDBFactory();
        EList solutions = editor.getModel().getSolutions();
        this.cmbSolution.add(SDbPlugin.getResourceString("STR_NEW_SOLUTION_LABEL"));
        int i = 0;
        while (i < solutions.size()) {
            this.cmbSolution.add(this.getFirstNonBlankLineFrom(((SDBSolution)solutions.get(i)).getDescription()));
            ++i;
        }
        this.solutionRegistry = new ArrayList();
        SDBSolution newSol = this.objFactory.createSDBSolution();
        newSol.setDescription(SDbPlugin.getResourceString("STR_NEW_SOLUTION_LABEL"));
        this.solutionRegistry.add(0, newSol);
        this.solutionRegistry.addAll(solutions);
    }

    public void display(EObject object) {
        this.isDisplaying = true;
        this.currentSel = (SDBSolution)object;
        if (this.solutionRegistry.indexOf(this.currentSel) > -1) {
            this.txtInfo.setText(this.currentSel.getDescription());
            this.cmbSolution.setText(this.getFirstNonBlankLineFrom(this.currentSel.getDescription()));
            this.cmbSolution.setEnabled(false);
        } else {
            this.txtInfo.setText(this.currentSel.getDescription());
            this.cmbSolution.setEnabled(true);
            this.cmbSolution.select(0);
        }
        this.isDisplaying = false;
    }

    public void setFocusToTextBox() {
        this.txtInfo.setFocus();
        this.txtInfo.setSelection(0, this.txtInfo.getText().length());
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.cmbSolution || source == this.txtInfo) {
            boolean status = false;
            if (source == this.cmbSolution) {
                int i = this.cmbSolution.getSelectionIndex();
                this.txtInfo.setText(((SDBSolution)this.solutionRegistry.get(i)).getDescription());
                this.currentSel = (SDBSolution)this.solutionRegistry.get(i);
            }
            if (source == this.txtInfo && !this.isDisplaying) {
                status = this.editor.validateState((Widget)this.txtInfo, this, this.currentSel.getDescription());
            }
            if (this.currentSel != null && !this.isDisplaying && status) {
                this.editor.updateUIDirtyStatus(true);
                this.editor.updateModelDirtyStatus(true);
            }
        }
    }

    public boolean updateCurrentSelection(EObject currentSelection) {
        if (this.cmbSolution.getSelectionIndex() == 0) {
            this.currentSel = (SDBSolution)currentSelection;
            this.currentSel.setDescription(this.txtInfo.getText());
            if (this.solutionRegistry.indexOf(this.currentSel) < 0) {
                this.updateSolutionRegistry(this.currentSel, true);
            }
        } else if (this.cmbSolution.isEnabled()) {
            SDBSymptom parent = (SDBSymptom)this.editor.detailsPage.getParentOfCurrentSel();
            SDBRuntime db = (SDBRuntime)this.editor.detailsPage.getTreeRoot();
            this.updateSolutionRegistry(this.currentSel, false);
            this.currentSel.setDescription(this.txtInfo.getText());
            parent.getSolutions().add((Object)this.currentSel);
            this.currentSel.getSymptoms().add((Object)parent);
            this.updateSolutionRegistry(this.currentSel, true);
            this.removeNewSolution((SDBSolution)currentSelection, parent, db);
        } else {
            this.updateSolutionRegistry(this.currentSel, false);
            this.currentSel = (SDBSolution)currentSelection;
            this.currentSel.setDescription(this.txtInfo.getText());
            this.updateSolutionRegistry(this.currentSel, true);
        }
        return true;
    }

    protected void updateSolutionRegistry(SDBSolution object, boolean add) {
        if (add) {
            this.solutionRegistry.add(object);
            this.cmbSolution.add(this.getFirstNonBlankLineFrom(object.getDescription()));
        } else if (this.solutionRegistry.indexOf(object) > -1) {
            this.cmbSolution.remove(this.solutionRegistry.indexOf(object));
            this.solutionRegistry.remove(object);
        }
    }

    private void removeNewSolution(SDBSolution current, SDBSymptom parent, SDBRuntime root) {
        parent.getSolutions().remove((Object)current);
        root.getSolutions().remove((Object)current);
        current.getSymptoms().remove((Object)parent);
        this.solutionRegistry.remove(current);
    }

    protected ArrayList getSolutionRegistry() {
        return this.solutionRegistry;
    }

    private String getFirstNonBlankLineFrom(String description) {
        String nl = "\r\n";
        if (description.indexOf("\r\n") < 0) {
            if (description.indexOf("\n") < 0) {
                return description;
            }
            nl = "\n";
        }
        int i = 0;
        int j = 0;
        String line = "";
        while (i <= description.length()) {
            j = description.indexOf(nl, i);
            if (j > -1) {
                line = description.substring(i, j);
                if (!line.equals("")) {
                    break;
                }
            } else {
                line = description.substring(i);
                break;
            }
            i = j + nl.length();
        }
        return line;
    }
}

