/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.internal.wizard;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.JavaUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.PartInitException;

public abstract class TestSuiteNewWizard
extends HyadesNewWizard {
    protected abstract String getType();

    protected String getFileExtension() {
        return "testsuite";
    }

    public void addPages() {
        this.addPage((IWizardPage)this.getLocationPage());
        this.addPage((IWizardPage)this.getAttributeWizardPage());
    }

    protected boolean createObject(IFile iFile) throws Exception {
        Resource resource = this.createResource(iFile);
        this.createObject(resource);
        Iterator iterator = resource.getResourceSet().getResources().iterator();
        while (iterator.hasNext()) {
            EMFUtil.save((Resource)((Resource)iterator.next()));
        }
        return true;
    }

    protected void createObject(Resource resource) {
        ITestSuite iTestSuite = HyadesFactory.INSTANCE.createTestSuite(resource);
        iTestSuite.setType(this.getType());
        iTestSuite.setName(this.getAttributeWizardPage().getItemName());
        String string = this.getAttributeWizardPage().getItemDescription();
        if (string != null && string.trim().length() > 0) {
            iTestSuite.setDescription(string);
        }
        if (iTestSuite.getImplementor() == null) {
            HyadesFactory.INSTANCE.createImplementor((ITest)iTestSuite, false);
        }
        this.registerResource(iTestSuite);
    }

    protected void registerResource(ITestSuite iTestSuite) {
        String string = JavaUtil.getValidClassName((String)iTestSuite.getName(), (boolean)true);
        if (string == null) {
            string = "Test";
        }
        iTestSuite.getImplementor().setResource("test." + string);
    }

    protected Resource createResource(IFile iFile) {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString());
        return resourceSetImpl.createResource(uRI);
    }

    protected void openEditor(IFile iFile) throws PartInitException {
        if (TestUIPlugin.getInstance().getPreferenceStore().getBoolean("openEditor")) {
            UIUtil.openEditor((IFile)iFile, (String)"org.eclipse.hyades.test.ui.editor.TestSuiteEditorPart", (boolean)false);
        }
    }
}

