/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.internal.ui.TraceUIManager;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class UIPlugin
extends AbstractUIPlugin
implements Application {
    protected static UIPlugin inst;
    protected ResourceBundle fResourceBundle;

    public UIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        if (inst == null) {
            inst = this;
        }
        try {
            this.fResourceBundle = this.getDescriptor().getResourceBundle();
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
    }

    public void addSelectionListener(ISelectionListener l) {
        TraceUIManager.getTraceUIManager().addSelectionListener(l);
    }

    public void removeSelectionListener(ISelectionListener l) {
        TraceUIManager.getTraceUIManager().removeSelectionListener(l);
    }

    public void addSelectionProvider(ISelectionProvider provider, IWorkbenchPart part) {
        TraceUIManager.getTraceUIManager().addSelectionProvider(provider, part);
    }

    public void deregisterLaunchProcess(IProcess process) {
        TraceUIManager.getTraceUIManager().deregisterLaunchProcess(process);
    }

    public void deleteLaunch(IProcess process) {
        TraceUIManager.getTraceUIManager().deleteLaunch(process);
    }

    public void registerLaunchProcess(IProcess process) {
        TraceUIManager.getTraceUIManager().registerLaunchProcess(process);
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchPage page;
        block5: {
            page = UIPlugin.getActiveWorkbenchWindow().getActivePage();
            if (page != null && page.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) break block5;
            IWorkbenchWindow dwindow = UIPlugin.getActiveWorkbenchWindow();
            page = null;
            try {
                IWorkbenchPage[] persps = dwindow.getPages();
                int idx = 0;
                while (idx < persps.length) {
                    if (persps[idx].getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) {
                        page = persps[idx];
                        dwindow.setActivePage(page);
                        break;
                    }
                    ++idx;
                }
                if (page != null) break block5;
                IWorkspaceRoot element = UIPlugin.getPluginWorkbench().getRoot();
                IWorkbench workBench = dwindow.getWorkbench();
                if (workBench != null && element != null) {
                    page = workBench.showPerspective("org.eclipse.hyades.trace.internal.ui.tracePerspective", UIPlugin.getActiveWorkbenchWindow(), (IAdaptable)element);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return page;
    }

    public static Shell getActiveWorkbenchShell() {
        return UIPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static UIPlugin getDefault() {
        return inst;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return PDPluginImages.getImageDescriptor(name);
    }

    public HierarchyFactory getPerftraceFactory() {
        return TraceUIManager.getTraceUIManager().getPerftraceFactory();
    }

    public static String getPluginId() {
        return UIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static IWorkspace getPluginWorkbench() {
        return ResourcesPlugin.getWorkspace();
    }

    public ResourceBundle getResourceBundle() {
        return this.fResourceBundle;
    }

    public ResourceSet getResourceSet() {
        return TraceUIManager.getTraceUIManager().getResourceSet();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = UIPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public PDProjectExplorer getViewer() {
        return PDProjectExplorer.getFromActivePerspective();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("use_host", "localhost:10002");
        store.setDefault("localhost_port", "10002");
        store.setDefault("prj_name", "ProfileProject");
        store.setDefault("mon_name", "DefaultMonitor");
        store.setDefault("log_option", false);
        store.setDefault("prof_option", true);
        store.setDefault("profile_tips", true);
        store.setDefault("new_snapshot_tips", true);
        store.setDefault("prof_exec_stat", true);
        store.setDefault("prof_heap_stat", true);
        store.setDefault("prof_heap_inst", false);
        store.setDefault("prof_auto_monitor", true);
        store.setDefault("refresh_type", 0);
        store.setDefault("refresh_int", 3);
        String def = UIPlugin.getResourceString("STR_DEFAULT_SET_NAME");
        store.setDefault("filter_name", def);
        String filters = TraceConstants.DEFAULT_FILTER_SET;
        store.setDefault("set_filters", filters);
        store.setDefault("prof_heap_size", true);
        store.setDefault("prof_execution", false);
        store.setDefault("prof_execution_boundary", false);
        store.setDefault("limitInvoc", false);
        store.setDefault("limitTime", false);
        store.setDefault("invoc_nb", "10000");
        store.setDefault("timeSec", "5");
        store.setDefault("collect_depth", "1");
    }

    public void removeSelectionProvider(ISelectionProvider provider, IWorkbenchPart part) {
        TraceUIManager.getTraceUIManager().removeSelectionProvider(provider, part);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        TraceUIManager.getTraceUIManager().selectionChanged(event);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        TraceUIManager.getTraceUIManager().selectionChanged(part, sel);
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        PDPluginImages.shutdown();
        TraceUIManager.getTraceUIManager().dispose();
        try {
            PDCoreUtil.detachAgents();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.fResourceBundle = null;
    }

    public void startup() throws CoreException {
        super.startup();
    }

    public void addProfileEventListener(IProfileEventListener listener) {
        TraceUIManager.getTraceUIManager().addProfileEventListener(listener);
    }

    public void removeProfileEventListener(IProfileEventListener listener) {
        TraceUIManager.getTraceUIManager().removeProfileEventListener(listener);
    }

    public void addDeleteListener(IDeleteListener listener) {
        TraceUIManager.getTraceUIManager().addDeleteListener(listener);
    }

    public void addViewSelectionChangedListener(IViewSelectionChangedListener listener) {
        TraceUIManager.getTraceUIManager().addViewSelectionChangedListener(listener);
    }

    public void addSelectionModel(EObject mofObject, ITraceSelection model) {
        TraceUIManager.getTraceUIManager().addSelectionModel(mofObject, model);
    }

    public ArrayList getDeleteListeners() {
        return TraceUIManager.getTraceUIManager().getDeleteListeners();
    }

    public ViewSelectionChangedEvent getViewSelectionChangedEvent() {
        return TraceUIManager.getTraceUIManager().getViewSelectionChangedEvent();
    }

    public ProfileEvent getProfileEvent() {
        return TraceUIManager.getTraceUIManager().getProfileEvent();
    }

    public ProfileEvent getRefreshViewEvent(Object source) {
        return TraceUIManager.getTraceUIManager().getRefreshViewEvent(source);
    }

    public ITraceSelection getSelectionModel(EObject mofObject) {
        return TraceUIManager.getTraceUIManager().getSelectionModel(mofObject);
    }

    public ProfileEvent getUpdateModelEvent(Object source) {
        return TraceUIManager.getTraceUIManager().getUpdateModelEvent(source);
    }

    public void notifyViewSelectionChangedListener(ViewSelectionChangedEvent event) {
        TraceUIManager.getTraceUIManager().notifyViewSelectionChangedListener(event);
    }

    public void notifyProfileEventListener(ProfileEvent event) {
        TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
    }

    public void removeDeleteListener(IDeleteListener listener) {
        TraceUIManager.getTraceUIManager().removeDeleteListener(listener);
    }

    public void removeViewSelectionChangedListener(IViewSelectionChangedListener listener) {
        TraceUIManager.getTraceUIManager().removeViewSelectionChangedListener(listener);
    }

    public void removeSelectionModel(EObject mofObject) {
        TraceUIManager.getTraceUIManager().removeSelectionModel(mofObject);
    }

    public String getName() {
        return UIPlugin.getPluginId();
    }
}

