/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileJavaApplicationDelegate;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.launcher.TraceArguments;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.JUnitLaunchConfiguration;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;

public class ProfileJUnitPluginDelegate
extends JUnitLaunchConfiguration {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 5);
            boolean success = ProfileJavaApplicationDelegate.performProfilingTypesLaunch(configuration);
            monitor.worked(1);
            if (!success) {
                monitor.setCanceled(true);
                return;
            }
            IJavaProject javaProject = this.getJavaProject(configuration);
            IType[] testTypes = this.getTestTypes(configuration, javaProject, null);
            IVMInstall launcher = LauncherUtils.createLauncher((ILaunchConfiguration)configuration);
            monitor.worked(1);
            int port = SocketUtil.findFreePort();
            VMRunnerConfiguration runConfig = this.createVMRunner(configuration, testTypes, port, mode);
            if (runConfig == null) {
                monitor.setCanceled(true);
                return;
            }
            String workspace = configuration.getAttribute("location0", this.getDefaultWorkspace(configuration));
            if (!LauncherUtils.clearWorkspace((ILaunchConfiguration)configuration, (String)workspace, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
                monitor.setCanceled(true);
                return;
            }
            this.setDefaultSourceLocator(launch, configuration);
            launch.setAttribute("org.eclipse.jdt.junit.PORT", Integer.toString(port));
            launch.setAttribute("org.eclipse.jdt.junit.TESTTYPE", testTypes[0].getHandleIdentifier());
            PDEPlugin.getDefault().getLaunchesListener().manage(launch);
            monitor.worked(1);
            ProfilingSetsManager manager = ProfilingSetsManager.instance();
            IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
            TraceArguments args = new TraceArguments(runConfig.getClassToLaunch());
            args.setClassPath(ProfileJUnitPluginDelegate.generateString(runConfig.getClassPath(), File.pathSeparatorChar));
            args.setParameters(ProfileJUnitPluginDelegate.generateString(runConfig.getProgramArguments(), ' '));
            args.setVMArguments(ProfileJUnitPluginDelegate.generateString(runConfig.getVMArguments(), ' '));
            args.setEnvironmentVariable(manager.getEnvironmentVariables(configuration));
            args.setAutoMonitoring(manager.getAutoMonitoring(configuration));
            args.setLocation(runConfig.getWorkingDirectory());
            String hostName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            port = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt("localhost_port"));
            String projectName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString("prj_name"));
            String monitorName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString("mon_name"));
            args.setHostName(hostName);
            args.setPortNumber(port);
            if (configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false)) {
                args.setProfileFile(configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String)null));
            }
            ArrayList filters = manager.getFilters(configuration);
            Vector options = manager.getOptions(configuration);
            monitor.worked(1);
            PDCoreUtil.launchTrace(args, filters, options, projectName, monitorName, launch);
            monitor.worked(1);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            throw e;
        }
    }

    private static String generateString(String[] array, char delimiter) {
        StringBuffer buf = new StringBuffer();
        if (array.length > 0) {
            int i = 0;
            while (i < array.length - 1) {
                buf.append(array[i]);
                buf.append(delimiter);
                ++i;
            }
            buf.append(array[array.length - 1]);
        }
        return buf.toString();
    }

    private String getDefaultWorkspace(ILaunchConfiguration config) throws CoreException {
        if (config.getAttribute("application", "org.eclipse.pde.junit.runtime.uitestapplication").equals("org.eclipse.pde.junit.runtime.uitestapplication")) {
            return LauncherUtils.getDefaultPath().append("junit-workbench-workspace").toOSString();
        }
        return LauncherUtils.getDefaultPath().append("junit-core-workspace").toOSString();
    }
}

