/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.util.EObjectVisitor;
import org.eclipse.hyades.models.hierarchy.util.FastList;

public abstract class EObjectsTraverser {
    protected static final int AFTER_CHILDREN = 3;
    protected static final int BEFORE_CHILDREN = 1;
    private Collection contents;
    private List visitors;

    public EObjectsTraverser(Collection contents) {
        this.contents = contents;
        this.visitors = new FastList();
    }

    public void dispose() {
        this.visitors.clear();
        this.contents = null;
    }

    protected boolean afterChildren(EObject element) {
        return this.callVisitors(3, element);
    }

    protected boolean beforeChildren(EObject element) {
        return this.callVisitors(1, element);
    }

    public EObjectsTraverser registerVisitors(EObjectVisitor visitor) {
        if (visitor != null) {
            this.visitors.add(visitor);
        }
        return this;
    }

    public EObjectsTraverser deregisterVisitor(EObjectVisitor visitor) {
        if (visitor != null) {
            this.visitors.remove(visitor);
        }
        return this;
    }

    public EObjectsTraverser deregisterAllVisitors() {
        this.visitors.clear();
        return this;
    }

    protected boolean callVisitors(int flag, EObject element) {
        boolean ret = true;
        int i = this.visitors.size() - 1;
        while (i >= 0) {
            try {
                switch (flag) {
                    case 1: {
                        ret = ((EObjectVisitor)this.visitors.get(i)).beforeChildren(element) && ret;
                        break;
                    }
                    case 3: {
                        ret = ((EObjectVisitor)this.visitors.get(i)).afterChildren(element) && ret;
                    }
                }
            }
            catch (RuntimeException re) {
                LoadersUtils.log(re);
            }
            --i;
        }
        return ret;
    }

    public boolean traverse() {
        return this.traverse(this.contents.iterator());
    }

    protected boolean traverse(Iterator iter) {
        while (iter.hasNext()) {
            EObject traversedElement = (EObject)iter.next();
            EObject visitorElement = this.getElement(traversedElement);
            if (!this.beforeChildren(visitorElement)) {
                return false;
            }
            this.traverseEObject(traversedElement);
            if (this.afterChildren(visitorElement)) continue;
            return false;
        }
        return true;
    }

    protected boolean traverse(List children) {
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            EObject traversedElement = (EObject)iter.next();
            EObject visitorElement = this.getElement(traversedElement);
            if (!this.beforeChildren(visitorElement)) {
                return false;
            }
            this.traverseEObject(visitorElement);
            if (this.afterChildren(visitorElement)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean traverseEObject(EObject var1);

    protected abstract EObject getElement(EObject var1);
}

