/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ColumnData;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.FilterElementModifier;
import org.eclipse.hyades.log.ui.internal.util.FilterList;
import org.eclipse.hyades.log.ui.internal.util.FilterListContentProvider;
import org.eclipse.hyades.log.ui.internal.util.FilterListLabelProvider;
import org.eclipse.hyades.log.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.log.ui.internal.util.LogAnalyzerUI;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class CBEAdvFilterUI
extends LogAnalyzerUI {
    private Composite result;
    private Button _addBtn;
    private Button _editBtn;
    private Button _removeBtn;
    private Button _upBtn;
    private Button _downBtn;
    private CheckboxTableViewer _tableViewer;
    private Table _table;
    private FilterList _filterList;
    private static String[] tableColumnProperties = new String[]{"attribute_combo", "operator_combo", "value_string"};
    public static String[] fAttributeValues;
    public static String[] fOperatorValues;
    private int iType;

    public CBEAdvFilterUI(int type) {
        this.iType = type;
    }

    public Control createControl(Composite parent) {
        return this.createControl(parent, LogUIPlugin.getResourceString("ADVANCE_FILTERS_LABEL"));
    }

    public Control createControl(Composite parent, String contentLabel) {
        this.initializeAttribute();
        this.result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        this.result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        this.result.setLayoutData((Object)data);
        Label _contentLabel = new Label(this.result, 0);
        _contentLabel.setText(contentLabel);
        data = new GridData();
        data.horizontalSpan = 2;
        _contentLabel.setLayoutData((Object)data);
        Composite tableGroup = new Composite(this.result, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        tableGroup.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.heightHint = 180;
        tableGroup.setLayoutData((Object)data);
        this.initializeTable(tableGroup);
        Composite btnGroup = new Composite(this.result, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite addGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        addGroup.setLayout((Layout)layout);
        addGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        this._addBtn = new Button(addGroup, 8);
        this._addBtn.setText(LogUIPlugin.getResourceString("ADD_FILTER_BTN"));
        this._addBtn.setToolTipText(LogUIPlugin.getResourceString("ADD_FILTER__BTN_TOOLTIP_TEXT"));
        this._addBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn = new Button(addGroup, 8);
        this._editBtn.setText(LogUIPlugin.getResourceString("EDIT_FILTER_BTN"));
        this._editBtn.setToolTipText(LogUIPlugin.getResourceString("EDIT_FILTER_BTN_TOOLTIP_TEXT"));
        this._editBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._removeBtn = new Button(addGroup, 8);
        this._removeBtn.setText(LogUIPlugin.getResourceString("REMOVE_FILTER_BTN"));
        this._removeBtn.setToolTipText(LogUIPlugin.getResourceString("REMOVE_FILTER_BTN_TOOLTIP_TEXT"));
        this._removeBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        Composite moveGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        moveGroup.setLayout((Layout)layout);
        moveGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._upBtn = new Button(moveGroup, 8);
        this._upBtn.setText(LogUIPlugin.getResourceString("MOVEUP_TEXT"));
        this._upBtn.setToolTipText(LogUIPlugin.getResourceString("MOVEUP_TOOLTIP_TEXT"));
        this._upBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._downBtn = new Button(moveGroup, 8);
        this._downBtn.setText(LogUIPlugin.getResourceString("MOVEDOWN_TEXT"));
        this._downBtn.setToolTipText(LogUIPlugin.getResourceString("MOVEDOWN_TOOLTIP_TEXT"));
        this._downBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn.setEnabled(false);
        this._removeBtn.setEnabled(false);
        this._upBtn.setEnabled(false);
        this._downBtn.setEnabled(false);
        this._upBtn.addSelectionListener((SelectionListener)this);
        this._downBtn.addSelectionListener((SelectionListener)this);
        this._addBtn.addSelectionListener((SelectionListener)this);
        this._editBtn.addSelectionListener((SelectionListener)this);
        this._removeBtn.addSelectionListener((SelectionListener)this);
        this._table.addSelectionListener((SelectionListener)this);
        this.setContextHelpIds();
        return this.result;
    }

    protected void initializeTable(Composite parent) {
        this.createTable(parent);
        this._tableViewer = new CheckboxTableViewer(this._table);
        this.createColumns();
        this._tableViewer.setContentProvider((IContentProvider)new FilterListContentProvider(this._tableViewer));
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new FilterListLabelProvider());
        this._filterList = new FilterList((TableViewer)this._tableViewer);
        this._tableViewer.setInput((Object)this._filterList);
        CellEditor[] editors = new CellEditor[this._table.getColumnCount()];
        editors[0] = new ComboBoxCellEditor((Composite)this._table, fAttributeValues);
        editors[1] = new ComboBoxCellEditor((Composite)this._table, fOperatorValues);
        editors[2] = new TextCellEditor((Composite)this._table);
        this._tableViewer.setCellEditors(editors);
        FilterElementModifier modifier = new FilterElementModifier(this._tableViewer);
        this._tableViewer.setCellModifier((ICellModifier)modifier);
        this._tableViewer.setColumnProperties(tableColumnProperties);
    }

    private void setContextHelpIds() {
        switch (this.iType) {
            case 0: {
                WorkbenchHelp.setHelp((Control)this._addBtn, (String)ContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_ADD);
                WorkbenchHelp.setHelp((Control)this._editBtn, (String)ContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_EDIT);
                WorkbenchHelp.setHelp((Control)this._removeBtn, (String)ContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_REMOVE);
                WorkbenchHelp.setHelp((Control)this._upBtn, (String)ContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_UP);
                WorkbenchHelp.setHelp((Control)this._downBtn, (String)ContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_DOWN);
                break;
            }
            case 1: {
                WorkbenchHelp.setHelp((Control)this._addBtn, (String)ContextIds.LOGINTER_VIEW_DIALOG_SEARCH_ADD);
                WorkbenchHelp.setHelp((Control)this._editBtn, (String)ContextIds.LOGINTER_VIEW_DIALOG_SEARCH_EDIT);
                WorkbenchHelp.setHelp((Control)this._removeBtn, (String)ContextIds.LOGINTER_VIEW_DIALOG_SEARCH_REMOVE);
                WorkbenchHelp.setHelp((Control)this._upBtn, (String)ContextIds.LOGINTER_VIEW_DIALOG_SEARCH_MOVE_UP);
                WorkbenchHelp.setHelp((Control)this._downBtn, (String)ContextIds.LOGINTER_VIEW_DIALOG_SEARCH_MOVE_DOWN);
                break;
            }
            case 2: {
                WorkbenchHelp.setHelp((Control)this._addBtn, (String)ContextIds.ACTLOG_VIEW_DIALOG_SEARCH_ADD);
                WorkbenchHelp.setHelp((Control)this._editBtn, (String)ContextIds.ACTLOG_VIEW_DIALOG_SEARCH_EDIT);
                WorkbenchHelp.setHelp((Control)this._removeBtn, (String)ContextIds.ACTLOG_VIEW_DIALOG_SEARCH_REMOVE);
                WorkbenchHelp.setHelp((Control)this._upBtn, (String)ContextIds.ACTLOG_VIEW_DIALOG_SEARCH_MOVE_UP);
                WorkbenchHelp.setHelp((Control)this._downBtn, (String)ContextIds.ACTLOG_VIEW_DIALOG_SEARCH_MOVE_DOWN);
            }
        }
    }

    private void createTable(Composite parent) {
        this._table = new Table(parent, 68354);
        this._table.setLinesVisible(true);
        this._table.setLayoutData((Object)GridUtil.createFill());
    }

    private void createColumns() {
        TableLayout layout = new TableLayout();
        this._table.setLayout((Layout)layout);
        this._table.setHeaderVisible(true);
        String[] headers = new String[]{LogUIPlugin.getResourceString("HEADER_ATTRIBUTE"), LogUIPlugin.getResourceString("HEADER_OPERATOR"), LogUIPlugin.getResourceString("HEADER_VALUE")};
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnPixelData(120, true), new ColumnPixelData(70, true), new ColumnPixelData(130, true)};
        TableColumn[] columns = new TableColumn[headers.length];
        int i = 0;
        while (i < headers.length) {
            layout.addColumnData(layouts[i]);
            TableColumn tc = new TableColumn(this._table, 0, i);
            tc.setResizable(layouts[i].resizable);
            tc.setText(headers[i]);
            columns[i] = tc;
            ++i;
        }
    }

    public void initializeFilters(String advFilters) {
        ArrayList _tableElements = FilterTableElement.createFilterTableElementFromString(advFilters);
        this.populateTable(_tableElements);
    }

    public void initializeValues(boolean defaultValue) {
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        String advFilters = defaultValue ? store.getDefaultString("pd_adv_filter_options") : store.getString("pd_adv_filter_options");
        this.initializeFilters(advFilters);
        if (defaultValue) {
            Event e = new Event();
            e.widget = this.result;
            e.type = 13;
            this.notifyListeners(new SelectionEvent(e));
        }
    }

    public void initializeAttribute() {
        int i;
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        String pdFilters = store.getString("pd_filter_options");
        ArrayList<String> tempList = new ArrayList<String>();
        ArrayList list = ColumnData.createColumnDataFromString(pdFilters);
        if (list != null) {
            i = 0;
            while (i < list.size()) {
                ColumnData data = (ColumnData)list.get(i);
                tempList.add(data.name());
                ++i;
            }
        }
        Collections.sort(tempList);
        if (tempList.size() > 0) {
            fAttributeValues = new String[tempList.size()];
            i = 0;
            while (i < tempList.size()) {
                CBEAdvFilterUI.fAttributeValues[i] = (String)tempList.get(i);
                ++i;
            }
        }
    }

    public boolean storeValues(IPreferenceStore store, String preferenceProperty) {
        return FilterTableElement.saveFilters(this._filterList.getFilters(), preferenceProperty, store);
    }

    public boolean storeValues(IPreferenceStore store) {
        return FilterTableElement.saveFilters(this._filterList.getFilters(), "pd_adv_filter_options", store);
    }

    public Composite getControl() {
        return this.result;
    }

    protected void enableButtons() {
        int selection = this._table.getSelectionIndex();
        int selectionCount = this._table.getSelectionCount();
        this._removeBtn.setEnabled(this._filterList.getSize() > 0 && selection != -1);
        this._editBtn.setEnabled(this._filterList.getSize() > 0 && selection != -1);
        this._upBtn.setEnabled(selection > 0 && selectionCount == 1);
        this._downBtn.setEnabled(selection >= 0 && selection < this._table.getItemCount() - 1 && selectionCount == 1);
    }

    protected void selectTableItem(Table table, int selection) {
        table.setFocus();
        table.setSelection(selection);
        table.showSelection();
    }

    private void showEditDialog(String title, String attribute, String operator, String value) {
        EditDialog dialog = new EditDialog(this.result.getShell(), title, attribute, operator, value);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            if (attribute == null) {
                FilterTableElement elem = new FilterTableElement(dialog.attribute(), dialog.operator(), dialog.value());
                this._filterList.add(elem, this._filterList.getSize());
                elem.setParent(this._filterList);
                this._tableViewer.refresh();
                this.selectTableItem(this._table, this._filterList.getSize() - 1);
            } else {
                int idx = this._table.getSelectionIndex();
                if (idx != -1) {
                    FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(idx);
                    sel.setAttribute(dialog.attribute());
                    sel.setOperator(dialog.operator());
                    sel.setValue(dialog.value());
                    this._tableViewer.refresh();
                }
            }
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._addBtn) {
            this.showEditDialog(LogUIPlugin.getResourceString("STR_ADD_FILTER_DLG"), null, null, null);
            this.enableButtons();
        } else if (event.widget == this._editBtn) {
            int idx = this._table.getSelectionIndex();
            if (idx != -1) {
                FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(idx);
                String attribute = sel.getAtrribute();
                String operator = sel.getOperator();
                String value = sel.getValue();
                this.showEditDialog(LogUIPlugin.getResourceString("STR_EDIT_FILTER_DLG"), attribute, operator, value);
            }
        } else {
            if (event.widget == this._table) {
                this.enableButtons();
                return;
            }
            if (event.widget == this._removeBtn) {
                int selection = this._table.getSelectionIndex();
                this._filterList.removeElements(this._table.getSelectionIndices());
                this._tableViewer.refresh();
                int size = this._filterList.getSize();
                if (size > 0) {
                    if (selection > 0 && selection < size) {
                        this.selectTableItem(this._table, selection - 1);
                    } else {
                        this.selectTableItem(this._table, 0);
                    }
                }
                this.enableButtons();
            } else if (event.widget == this._upBtn) {
                this._tableViewer.refresh();
                int selection = this._table.getSelectionIndex();
                if (selection > 0) {
                    FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(selection);
                    FilterTableElement previous = (FilterTableElement)this._filterList.getElementAt(selection - 1);
                    String attribute = sel.getAtrribute();
                    String operator = sel.getOperator();
                    String value = sel.getValue();
                    sel.setAttribute(previous.getAtrribute());
                    sel.setOperator(previous.getOperator());
                    sel.setValue(previous.getValue());
                    previous.setAttribute(attribute);
                    previous.setOperator(operator);
                    previous.setValue(value);
                    this.selectTableItem(this._table, selection - 1);
                }
                this._tableViewer.refresh();
                this.enableButtons();
            } else if (event.widget == this._downBtn) {
                this._tableViewer.refresh();
                int selection = this._table.getSelectionIndex();
                if (selection < this._table.getItemCount() - 1) {
                    FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(selection);
                    FilterTableElement next = (FilterTableElement)this._filterList.getElementAt(selection + 1);
                    String attribute = sel.getAtrribute();
                    String operator = sel.getOperator();
                    String value = sel.getValue();
                    sel.setAttribute(next.getAtrribute());
                    sel.setOperator(next.getOperator());
                    sel.setValue(next.getValue());
                    next.setAttribute(attribute);
                    next.setOperator(operator);
                    next.setValue(value);
                    this.selectTableItem(this._table, selection + 1);
                }
                this._tableViewer.refresh();
                this.enableButtons();
            }
        }
    }

    protected void populateTable(ArrayList tableElems) {
        this._filterList.removeAll();
        if (tableElems != null) {
            int idx = 0;
            while (idx < tableElems.size()) {
                FilterTableElement elem = (FilterTableElement)tableElems.get(idx);
                this._filterList.add(elem, this._filterList.getSize());
                elem.setParent(this._filterList);
                ++idx;
            }
            if (tableElems.size() > 0) {
                this._table.select(0);
            }
        }
        this._tableViewer.refresh();
        this.enableButtons();
    }

    protected void populateList() {
    }

    public Button getAddBtn() {
        return this._addBtn;
    }

    public Button getRemoveBtn() {
        return this._removeBtn;
    }

    public FilterList getFilterList() {
        return this._filterList;
    }

    static {
        fOperatorValues = new String[]{LogUIPlugin.getResourceString("STR_EQUAL"), LogUIPlugin.getResourceString("STR_NOT_EQUAL"), LogUIPlugin.getResourceString("STR_LARGER_THAN"), LogUIPlugin.getResourceString("STR_SMALLER_THAN")};
    }

    class EditDialog
    extends Dialog
    implements ModifyListener {
        private String _attribute;
        private String _operator;
        private String _value;
        private Combo _AttributeText;
        private Combo _OperatorText;
        private Text _ValueText;
        private String _title;

        public EditDialog(Shell shell, String title, String attribute, String operator, String value) {
            super(shell);
            this._attribute = attribute;
            this._operator = operator;
            this._value = value;
            this._title = title;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        public void attribute(String attribute) {
            this._attribute = attribute;
        }

        public String attribute() {
            return this._attribute;
        }

        public void operator(String operator) {
            this._operator = operator;
        }

        public String operator() {
            return this._operator;
        }

        public void value(String value) {
            this._value = value;
        }

        public String value() {
            return this._value;
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.widthHint = 400;
            result.setLayoutData((Object)data);
            Label label = new Label(result, 0);
            label.setText(LogUIPlugin.getResourceString("HEADER_ATTRIBUTE"));
            this._AttributeText = new Combo(result, 2056);
            this._AttributeText.setLayoutData((Object)GridUtil.createHorizontalFill());
            int i = 0;
            while (i < fAttributeValues.length) {
                this._AttributeText.add(fAttributeValues[i]);
                ++i;
            }
            label = new Label(result, 0);
            label.setText(LogUIPlugin.getResourceString("HEADER_OPERATOR"));
            this._OperatorText = new Combo(result, 2056);
            this._OperatorText.setLayoutData((Object)GridUtil.createHorizontalFill());
            int i2 = 0;
            while (i2 < fOperatorValues.length) {
                this._OperatorText.add(fOperatorValues[i2]);
                ++i2;
            }
            label = new Label(result, 0);
            label.setText(LogUIPlugin.getResourceString("HEADER_VALUE"));
            this._ValueText = new Text(result, 2048);
            this._ValueText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._AttributeText.select(0);
            this._OperatorText.select(0);
            this._ValueText.addModifyListener((ModifyListener)this);
            if (this._attribute != null) {
                this._AttributeText.setText(this._attribute);
            }
            if (this._operator != null) {
                this._OperatorText.setText(this._operator);
            }
            if (this._value != null) {
                this._ValueText.setText(this._value);
            }
            this._AttributeText.setFocus();
            this.setContextHelpId((Control)result);
            return result;
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == this._ValueText && this.getButton(0) != null) {
                this.getButton(0).setEnabled(this._ValueText.getText().trim() != "");
            }
        }

        protected void okPressed() {
            this._attribute = this._AttributeText.getText().trim();
            this._operator = this._OperatorText.getText().trim();
            this._value = this._ValueText.getText();
            super.okPressed();
        }

        private void setContextHelpId(Control control) {
            switch (CBEAdvFilterUI.this.iType) {
                case 0: {
                    WorkbenchHelp.setHelp((Control)control, (String)ContextIds.ACTLOG_VIEW_DIALOG_FILTER);
                    break;
                }
                case 1: {
                    WorkbenchHelp.setHelp((Control)control, (String)ContextIds.LOGINTER_VIEW_DIALOG_FILTER);
                    break;
                }
                case 2: {
                    WorkbenchHelp.setHelp((Control)control, (String)ContextIds.ACTLOG_VIEW_DIALOG_SEARCH);
                }
            }
        }
    }
}

