/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class ColumnData {
    private String _name;
    private boolean _visible = false;

    public ColumnData(String name, boolean visible) {
        this._name = name;
        this._visible = visible;
    }

    public static ArrayList createColumnData(String preferenceKey, String defaultColumns) {
        String preferenceColumns = LogUIPlugin.getDefault().getPreferenceStore().getString(preferenceKey);
        if (preferenceColumns == null || preferenceColumns.length() == 0) {
            preferenceColumns = defaultColumns;
        }
        return ColumnData.createColumnDataFromString(preferenceColumns);
    }

    public static ArrayList createColumnDataFromString(String preferenceColumns) {
        ArrayList columnDataList = null;
        if (preferenceColumns != null && !preferenceColumns.equals("")) {
            int count = 1;
            int i = preferenceColumns.indexOf(" ");
            while (i != -1) {
                ++count;
                i = preferenceColumns.indexOf(",", i + 1);
            }
            columnDataList = new ArrayList(count);
            int idx = 0;
            while (idx != -1) {
                String columnDataTemplate;
                idx = preferenceColumns.indexOf(" ");
                if (idx != -1) {
                    columnDataTemplate = preferenceColumns.substring(0, idx);
                    preferenceColumns = preferenceColumns.substring(idx + 1);
                } else {
                    columnDataTemplate = preferenceColumns;
                }
                ColumnData.addColumnData(columnDataTemplate, columnDataList);
            }
        }
        return columnDataList;
    }

    private static void addColumnData(String columnTemplate, ArrayList list) {
        String columnName = "";
        boolean visible = false;
        int idx = columnTemplate.indexOf(":");
        if (idx != -1) {
            columnName = columnTemplate.substring(0, idx);
            columnTemplate = columnTemplate.substring(idx + 1);
        } else {
            columnName = columnTemplate;
        }
        if (columnTemplate.equals("1")) {
            visible = true;
        }
        list.add(new ColumnData(columnName, visible));
    }

    public static void setColumns(ArrayList newList, ArrayList currentList, String preferenceKey, IPreferenceStore store) {
        currentList.clear();
        currentList.addAll(newList);
        ColumnData.setColumns(currentList, preferenceKey, store);
    }

    public static void setColumns(ArrayList currentList, String preferenceKey, IPreferenceStore store) {
        String columnName = "";
        String columns = "";
        int i = 0;
        while (i < currentList.size()) {
            ColumnData columnData = (ColumnData)currentList.get(i);
            columnName = columnData.name();
            columns = columnData.visible() ? columns + " " + columnName + ":1" : columns + " " + columnName + ":0";
            ++i;
        }
        if (columns.startsWith(" ") && columns.length() > 1) {
            columns = columns.substring(1);
        }
        store.setValue(preferenceKey, columns);
    }

    public String name() {
        return this._name;
    }

    public void name(String name) {
        this._name = name;
    }

    public boolean visible() {
        return this._visible;
    }

    public void visible(boolean visible) {
        this._visible = visible;
    }
}

