/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.CBEFilterUI;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;

public class ColumnsDialog
extends Dialog
implements SelectionListener {
    private CBEFilterUI _options;
    private static final int _restoreDefaultsButtonId = 1025;
    private boolean filterHasChanged = false;
    private boolean sevHasChanged = false;
    private String _title;

    public ColumnsDialog(Shell shell, String windowTitle, Image windowImage) {
        super(shell);
        this._title = windowTitle;
        Window.setDefaultImage((Image)windowImage);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 15;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        data.heightHint = 400;
        data.widthHint = 370;
        result.setLayoutData((Object)data);
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        this._options = new CBEFilterUI();
        this._options.createControl(result);
        this._options.initializeValues(false);
        this._options.addListener(this);
        WorkbenchHelp.setHelp((Control)result, (String)ContextIds.ACTLOG_VIEW_DIALOG_FILTER);
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, LogUIPlugin.getResourceString("STR_COL_DLG_RESTORE_DEFAULTS"), false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this._options.initializeValues(true);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        boolean flag = this._options.storeValues(LogUIPlugin.getDefault().getPreferenceStore());
        if (flag) {
            this._options.removeListener(this);
        }
        if (this.filterHasChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(1, (Object)this));
        }
        if (this.sevHasChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(2, (Object)this));
        }
        if (flag) {
            super.okPressed();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Widget widget = e.widget;
        if (widget instanceof Button && (((Button)widget).getStyle() & 0x20) == 32) {
            this.sevHasChanged = true;
        } else if (widget == this._options.getControl()) {
            this.sevHasChanged = true;
            this.filterHasChanged = true;
        } else {
            this.filterHasChanged = true;
        }
    }

    protected void cancelPressed() {
        this._options.removeListener(this);
        super.cancelPressed();
    }
}

